package com.atlassian.jira.event.issue.commit;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.JiraIssueEvent;

/**
 * This is a wrapper of issue events. The {@link OnCommitIssueEvent} is supposed to be fired on
 * commit if it's in a transaction, otherwise fired immediately.
 * <p>
 * While the {@link IssueEvent} may be fired before commit.
 * <p>
 * This means that when listening to {@link IssueEvent} event, inaccurate data may be retrieved from database,
 * while listening to {@link OnCommitIssueEvent} guarantees the correct data.
 * <p>
 * There is no guarantee that the data in the wrapped {@link JiraIssueEvent} has been updated after the commit,
 * and before publishing this message. However {@link #getOnCommitEventDataReloadStatus()} and
 * {@link #getOnCommitEventTransactionStatus()} can be used as a guide.
 *
 * @since 7.4.0
 */
@ExperimentalApi
public interface OnCommitIssueEvent extends OnCommitEvent<IssueEvent> {
}
