package com.atlassian.jira.event.issue;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.event.AbstractEvent;

@EventName("jql.search.version")
public class JqlSearchVersionEvent extends AbstractEvent {
    private final String fieldName;
    private final String operator;

    public JqlSearchVersionEvent(String fieldName, String operator) {
        this.fieldName = fieldName;
        this.operator = operator;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getOperator() {
        return operator;
    }
}
