package com.atlassian.jira.event.issue;

import com.atlassian.annotations.ExperimentalApi;

import java.util.Collection;
import java.util.Collections;

/**
 * Event published when issue is restored
 *
 * @since 8.1
 */
@ExperimentalApi
public class IssuesRestoredEvent extends AbstractArchivingEvent {
    public IssuesRestoredEvent(Collection<Long> issueIds) {
        super(issueIds);
    }

    public IssuesRestoredEvent(Long issueId) {
        super(Collections.singleton(issueId));
    }
}
