package com.atlassian.jira.event.issue;

import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;

import javax.annotation.Nullable;
import java.util.Optional;

/**
 * Event that is triggered when user stops watching an issue.
 *
 * @since v5.2
 */
public class IssueWatcherDeletedEvent extends AbstractEvent implements IssueRelatedEvent {
    private final Issue issue;
    private final ApplicationUser user;
    private final SpanningOperation spanningOperation;

    public IssueWatcherDeletedEvent(Issue issue, ApplicationUser user) {
        this(issue, user, null);
    }

    public IssueWatcherDeletedEvent(Issue issue, ApplicationUser user, @Nullable SpanningOperation spanningOperation) {
        this.issue = issue;
        this.user = user;
        this.spanningOperation = spanningOperation;
    }

    public Issue getIssue() {
        return issue;
    }

    /**
     * @deprecated Use {@link #getApplicationUser()} instead. Since v6.0.
     */
    public ApplicationUser getUser() {
        return user;
    }

    public ApplicationUser getApplicationUser() {
        return user;
    }

    @Override
    public Optional<SpanningOperation> getSpanningOperation() {
        return Optional.ofNullable(spanningOperation);
    }
}
