package com.atlassian.jira.event.issue;

import com.atlassian.annotations.ExperimentalApi;

import java.util.Collection;
import java.util.Objects;

/**
 * Abstract event related to archiving actions.
 *
 * @since 8.0
 */
@ExperimentalApi
public abstract class AbstractArchivingEvent {
    private final Collection<Long> issueIds;

    AbstractArchivingEvent(Collection<Long> issueIds) {
        this.issueIds = issueIds;
    }

    public Collection<Long> getIssueIds() {
        return issueIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AbstractArchivingEvent that = (AbstractArchivingEvent) o;
        return Objects.equals(issueIds, that.issueIds);
    }

    @Override
    public int hashCode() {

        return Objects.hash(issueIds);
    }
}
