package com.atlassian.jira.event.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.issue.priority.Priority;

import java.util.Objects;

/**
 * Published when issue priority is successfully deleted.
 */
@Internal
public class PriorityDeletedEvent extends AbstractEvent {
    private final Priority priority;

    public PriorityDeletedEvent(Priority priority) {
        super();
        this.priority = priority;
    }

    public Priority getPriority() {
        return priority;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PriorityDeletedEvent that = (PriorityDeletedEvent) o;
        return Objects.equals(priority, that.priority);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), priority);
    }

    @Override
    public String toString() {
        return "PriorityDeletedEvent{" +
                "priority=" + priority +
                '}';
    }
}
