package com.atlassian.jira.event;

import com.atlassian.analytics.api.annotations.EventName;

/**
 * Fired after a successful issue list export.
 *
 * @since v7.2
 */
public class ExportEvent extends AbstractEvent {

    private final String key;
    private final String delimiter;

    public ExportEvent(final String key) {
        super();
        this.key = key;
        this.delimiter = "";
    }

    public ExportEvent(final String key, final String delimiter) {
        super();
        this.key = key;
        this.delimiter = delimiter;
    }

    public String getKey() {
        return key;
    }

    public String getDelimiter() {
        return delimiter;
    }

    @EventName
    public String calculateEventName() {
        return "jira.export." + getKey();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {

        private final static String ALL_FIELDS_KEY = "searchrequest-csv-all-fields";
        private final static String CURRENT_FIELDS_KEY = "searchrequest-csv-current-fields";

        private String key;
        private String delimiter;

        private Builder() {
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public ExportEvent build() {
            if (key == null) throw new IllegalArgumentException();

            if (delimiter != null && (key.equals(ALL_FIELDS_KEY) || key.equals(CURRENT_FIELDS_KEY))) {
                return new ExportEvent(key, delimiter);
            } else {
                return new ExportEvent(key);
            }
        }

    }

}
