package com.atlassian.jira.config.properties;

import com.atlassian.plugin.webresource.WebResourceIntegration;

/**
 * A bean responsible for storing and maintaining the system hash component of the resource URIs. See {@link WebResourceIntegration#getSystemCounter()}
 */
public interface UiSettingsStateManager {
    /**
     * @return the current hash.
     */
    String getStateHash();

    /**
     * Invalidates the current hash. The next call to {@link #getStateHash()} will trigger a recalculation.
     */
    void invalidateStateHash();
}
