package com.atlassian.jira.config.feature;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.jira.config.FeatureFlag;

import javax.annotation.Nonnull;
import java.util.Set;

/**
 * This interface defines a way to activate feature flags using external logic,
 * not related to feature flag itself.
 * <p>
 * For example you could use the JIRA build number to evaluate if flag should be activated.
 *
 * @since v7.6
 */
@ExperimentalSpi
public interface FeatureFlagActivator {

    /**
     * Return a set of feature flags that should be considered as activated (ie. enabled).
     * <p>
     * NB: The {@link FeatureFlag} returned from this method must return false from {@link FeatureFlag#isOnByDefault()}
     * and therefore be off by default, to be considered valid.
     */
    @Nonnull
    Set<FeatureFlag> getActivatedFlags();

}
