package com.atlassian.jira.cluster.zdu;

import com.atlassian.annotations.ExperimentalApi;

import java.util.Collection;

/**
 * This event is fired when the cluster enters {@link UpgradeState#UPGRADE_TASKS_FAILED} state due to the upgrade
 * having thrown an exception.
 *
 * @since v7.4
 * @see UpgradeState#RUNNING_UPGRADE_TASKS
 */
@ExperimentalApi
public class JiraUpgradeFailedEvent {
    private final NodeBuildInfo fromVersion;
    private final NodeBuildInfo toVersion;
    private final Collection<String> errors;

    public JiraUpgradeFailedEvent(final NodeBuildInfo fromVersion, final NodeBuildInfo toVersion, final Collection<String> errors) {
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.errors = errors;
    }

    public NodeBuildInfo getFromVersion() {
        return fromVersion;
    }

    public NodeBuildInfo getToVersion() {
        return toVersion;
    }

    public Collection<String> getErrors() {
        return errors;
    }
}
