package com.atlassian.jira.bc.issue.fields.screen;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * An object expressing identifier of given screen's tab
 *
 * @see FieldScreenId
 * @since v7.4
 */
@ExperimentalApi
public class FieldScreenTabId {
    private final long id;

    private FieldScreenTabId(long id) {
        this.id = id;
    }

    /**
     * Creates new identifier based on actual already existing {@link FieldScreenTab} object
     *
     * @param tab a tab we want get identifier of
     * @return a tab's identifier
     */
    public static FieldScreenTabId of(FieldScreenTab tab) {
        return new FieldScreenTabId(tab.getId());
    }

    /**
     * Creates identifier based on abstract raw-data identifier. Tab itself may or may not be existing.
     *
     * @param id id of a tab
     * @return a tab's identifier
     */
    public static FieldScreenTabId byId(long id) {
        return new FieldScreenTabId(id);
    }

    public long getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FieldScreenTabId that = (FieldScreenTabId) o;

        return id == that.id;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(id);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("id", id)
                .toString();
    }
}
