package com.atlassian.jira.bc.issue.fields.screen;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.builder.ToStringBuilder;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * An object expressing identifier of given {@link FieldScreen}
 *
 * @since v7.4
 */
@ExperimentalApi
@ParametersAreNonnullByDefault
public class FieldScreenId {
    private final long id;

    private FieldScreenId(final long id) {
        this.id = Preconditions.checkNotNull(id);
    }

    /**
     * Creates instance of {@link FieldScreenId} based on actual existing instance of {@link FieldScreen}
     *
     * @param screen screen
     * @return identifier object
     */
    public static FieldScreenId of(final FieldScreen screen) {
        return new FieldScreenId(screen.getId());
    }

    /**
     * Creates identifier based on abstract raw-data identifier. Screen itself may or may not be existing.
     *
     * @param id id of a screen
     * @return identifier object
     */
    public static FieldScreenId byId(final long id) {
        return new FieldScreenId(id);
    }

    public long getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FieldScreenId that = (FieldScreenId) o;

        return id == that.id;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(id);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("id", id)
                .toString();
    }
}
