package com.atlassian.jira.bc.dataimport;

/**
 * Event raised when XML server export finishes with a failure.
 *
 * @since v8.0
 */
public class ExportFailedEvent implements DataExportEvent {

    enum Reason { INVALID_XML, GENERIC, ACTIVE_OBJECTS, IO }

    private final long xmlExportTime;
    private final long exportDuration;
    private final Reason reason;

    ExportFailedEvent(long xmlExportTime, long exportDuration, Reason reason) {
        this.xmlExportTime = xmlExportTime;
        this.exportDuration = exportDuration;
        this.reason = reason;
    }

    @Override
    public Long getXmlExportTime() {
        return xmlExportTime;
    }

    public long getExportDuration() {
        return exportDuration;
    }

    public Reason getReason() {
        return reason;
    }
}
