package com.atlassian.jira.bc.dataimport;

import com.atlassian.annotations.PublicApi;
import io.atlassian.fugue.Option;

/**
 * The interface implemented by events related to JIRA data import.
 *
 * @since v6.2
 */
@PublicApi
public interface DataImportEvent {

    enum ImportType {
        CLOUD, SERVER, UNKNOWN
    }

    /**
     * @return time in milliseconds when the imported data was exported.
     */
    Option<Long> getXmlExportTime();
}
