package com.atlassian.jira.auditing;

import com.atlassian.annotations.ExperimentalApi;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Optional.ofNullable;

/**
 * Possible values for auditing category.
 *
 * @since v6.2
 *
 * @deprecated since v8.12<br/>
 * Instead you can use {@link AuditCategory}.
 */
@Deprecated
@ExperimentalApi
public enum AuditingCategory {
    AUDITING("auditing", AuditCategory.AUDITING),
    ADVANCED_AUDITING("advanced auditing", AuditCategory.ADVANCED_AUDITING),
    USER_MANAGEMENT("user management", AuditCategory.USER_MANAGEMENT),
    GROUP_MANAGEMENT("group management", AuditCategory.GROUP_MANAGEMENT),
    PERMISSIONS("permissions", AuditCategory.PERMISSIONS),
    WORKFLOWS("workflows", AuditCategory.WORKFLOWS),
    NOTIFICATIONS("notifications", AuditCategory.NOTIFICATIONS),
    FIELDS("fields", AuditCategory.FIELDS),
    PROJECTS("projects", AuditCategory.PROJECTS),
    SYSTEM("system", AuditCategory.SYSTEM),
    MIGRATION("migration", AuditCategory.MIGRATION),
    APPLICATIONS("applications", AuditCategory.APPLICATIONS),
    USER_DATA_TRANSFER("user data transfer", AuditCategory.USER_DATA_TRANSFER),
    SPRINTS("sprints", AuditCategory.SPRINTS),
    BOARDS("boards ", AuditCategory.BOARDS),
    ISSUE_TYPES("issue types", AuditCategory.ISSUE_TYPES),
    ISSUE("issue", AuditCategory.ISSUE),
    GENERAL_CONFIGURATION("configuration", AuditCategory.GENERAL_CONFIGURATION),
    DASHBOARDS("dashboards", AuditCategory.DASHBOARDS),
    FILTERS("filters", AuditCategory.FILTERS),
    SEARCH("search", AuditCategory.SEARCH),
    MAIL_SETTINGS("mail settings", AuditCategory.MAIL_SETTINGS),
    USER_INTERFACE("user interface", AuditCategory.USER_INTERFACE),
    SCREENS("screens", AuditCategory.SCREENS),
    INDEXING("indexing", AuditCategory.INDEXING),
    LOGIN("login", AuditCategory.LOGIN),
    FIELD_CONFIG_SCHEME("field config scheme", AuditCategory.FIELD_CONFIG_SCHEME),
    CLUSTERING("clustering", AuditCategory.CLUSTERING),
    SECURITY("security", AuditCategory.SECURITY),
    ECOSYSTEM("ecosystem", AuditCategory.ECOSYSTEM),
    ISSUE_SECURITY_LEVEL("issue security level", AuditCategory.ISSUE_SECURITY_LEVEL);

    private final String id;
    private final String nameI18nKey;

    AuditingCategory(final String id, final String nameI18nKey) {
        this.id = id;
        this.nameI18nKey = nameI18nKey;
    }

    public String getId() {
        return id;
    }

    public String getNameI18nKey() {
        return nameI18nKey;
    }

    @Nullable
    public static AuditingCategory getCategoryById(String categoryId) {
        for (AuditingCategory category : values()) {
            if (category.getId().equalsIgnoreCase(categoryId)) return category;
        }
        return null;
    }

    @Nullable
    public static AuditingCategory getCategoryByNameI18nKey(String nameI18nKey) {
        for (AuditingCategory category : values()) {
            if (category.getNameI18nKey().equalsIgnoreCase(nameI18nKey)) return category;
        }
        return null;
    }

    @Nullable
    public static AuditingCategory getCategoryByIdOrName(String idOrName) {
        for (AuditingCategory category : values()) {
            if (category.getId().equalsIgnoreCase(idOrName)) return category;
        }

        for (AuditingCategory category : values()) {
            if (category.name().equalsIgnoreCase(idOrName)) return category;
        }

        return null;
    }

    @Nonnull
    public static AuditingCategory getCategoryByNameI18nKeyWithFallback(String nameI18nKey, AuditingCategory fallback) {
        return ofNullable(getCategoryByNameI18nKey(nameI18nKey)).orElse(fallback);
    }
}
