/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.util;

import org.apache.commons.lang3.StringUtils;

public class ChartReportUtils {
    public static final String PROJECT_PARAM_PREFIX = "project-";
    public static final String FILTER_PARAM_PREFIX = "filter-";

    private ChartReportUtils() {
    }

    public static boolean isValidProjectParamFormat(String projectOrFilterId) {
        return ChartReportUtils.isValidParamFormat(projectOrFilterId, PROJECT_PARAM_PREFIX);
    }

    public static boolean isValidFilterParamFormat(String projectOrFilterId) {
        return ChartReportUtils.isValidParamFormat(projectOrFilterId, FILTER_PARAM_PREFIX);
    }

    private static boolean isValidParamFormat(String projectOrFilterId, String prefix) {
        String id = ChartReportUtils.extractProjectOrFilterId(projectOrFilterId);
        return StringUtils.isNotEmpty((CharSequence)id) && projectOrFilterId.startsWith(prefix);
    }

    public static String extractProjectOrFilterId(String projectOrFilterId) {
        int startOfId;
        if (StringUtils.isNotEmpty((CharSequence)projectOrFilterId) && (startOfId = projectOrFilterId.indexOf(45)) != -1) {
            return projectOrFilterId.substring(startOfId + 1);
        }
        return null;
    }
}

