/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.constants;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ThreadSafe
public class UserFieldSearchConstants
implements ClauseInformation {
    private final String indexField;
    private final ClauseNames jqlClauseNames;
    private final String searcherId;
    private final String fieldUrlParameter;
    private final String selectUrlParameter;
    private final String currentUserSelectFlag;
    private final String specificUserSelectFlag;
    private final String specificGroupSelectFlag;
    private final String fieldId;
    private final Set<Operator> supportedOperators;

    public UserFieldSearchConstants(String indexField, ClauseNames names, String fieldUrlParameter, String selectUrlParameter, String searcherId, String fieldId, String currentUserSelectFlag, String specificUserSelectFlag, String specificGroupSelectFlag, Set<Operator> supportedOperators) {
        this.fieldId = Assertions.notBlank("fieldId", fieldId);
        this.currentUserSelectFlag = Assertions.notNull("currentUserSelectFlag", currentUserSelectFlag);
        this.specificUserSelectFlag = Assertions.notNull("specificUserSelectFlag", specificUserSelectFlag);
        this.specificGroupSelectFlag = Assertions.notNull("specificGroupSelectFlag", specificGroupSelectFlag);
        this.fieldUrlParameter = Assertions.notBlank("fieldUrlParameter", fieldUrlParameter);
        this.selectUrlParameter = Assertions.notBlank("selectUrlParameter", selectUrlParameter);
        this.indexField = Assertions.notBlank("indexField", indexField);
        this.jqlClauseNames = Assertions.notNull("names", names);
        this.searcherId = Assertions.notBlank("searcherId", searcherId);
        this.supportedOperators = Assertions.notNull("supportedOperators", supportedOperators);
    }

    public UserFieldSearchConstants(String indexField, String jqlClauseName, String fieldUrlParameter, String selectUrlParameter, String searcherId, String emptySelectFlag, String fieldId, Set<Operator> supportedOperators) {
        this(indexField, new ClauseNames(Assertions.notBlank("jqlClauseNames", jqlClauseName)), fieldUrlParameter, selectUrlParameter, searcherId, fieldId, "issue_current_user", "specificuser", "specificgroup", supportedOperators);
    }

    @Override
    public String getIndexField() {
        return this.indexField;
    }

    @Override
    public ClauseNames getJqlClauseNames() {
        return this.jqlClauseNames;
    }

    public String getSearcherId() {
        return this.searcherId;
    }

    public String getFieldUrlParameter() {
        return this.fieldUrlParameter;
    }

    public String getSelectUrlParameter() {
        return this.selectUrlParameter;
    }

    public String getCurrentUserSelectFlag() {
        return this.currentUserSelectFlag;
    }

    public String getSpecificGroupSelectFlag() {
        return this.specificGroupSelectFlag;
    }

    public String getSpecificUserSelectFlag() {
        return this.specificUserSelectFlag;
    }

    @Override
    public String getFieldId() {
        return this.fieldId;
    }

    @Override
    public Set<Operator> getSupportedOperators() {
        IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager = ComponentAccessor.getComponentOfType(IndexedChangeHistoryFieldManager.class);
        if (indexedChangeHistoryFieldManager != null) {
            return indexedChangeHistoryFieldManager.getSupportedOperators(this.getFieldId(), this.supportedOperators);
        }
        return this.supportedOperators;
    }

    @Override
    public JiraDataType getDataType() {
        return JiraDataTypes.USER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFieldSearchConstants that = (UserFieldSearchConstants)o;
        if (this.currentUserSelectFlag != null ? !this.currentUserSelectFlag.equals(that.currentUserSelectFlag) : that.currentUserSelectFlag != null) {
            return false;
        }
        if (this.fieldId != null ? !this.fieldId.equals(that.fieldId) : that.fieldId != null) {
            return false;
        }
        if (this.fieldUrlParameter != null ? !this.fieldUrlParameter.equals(that.fieldUrlParameter) : that.fieldUrlParameter != null) {
            return false;
        }
        if (this.indexField != null ? !this.indexField.equals(that.indexField) : that.indexField != null) {
            return false;
        }
        if (this.jqlClauseNames != null ? !this.jqlClauseNames.equals(that.jqlClauseNames) : that.jqlClauseNames != null) {
            return false;
        }
        if (this.searcherId != null ? !this.searcherId.equals(that.searcherId) : that.searcherId != null) {
            return false;
        }
        if (this.selectUrlParameter != null ? !this.selectUrlParameter.equals(that.selectUrlParameter) : that.selectUrlParameter != null) {
            return false;
        }
        if (this.specificGroupSelectFlag != null ? !this.specificGroupSelectFlag.equals(that.specificGroupSelectFlag) : that.specificGroupSelectFlag != null) {
            return false;
        }
        if (this.specificUserSelectFlag != null ? !this.specificUserSelectFlag.equals(that.specificUserSelectFlag) : that.specificUserSelectFlag != null) {
            return false;
        }
        return !(this.supportedOperators != null ? !this.supportedOperators.equals(that.supportedOperators) : that.supportedOperators != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

