/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.util.SearchRequestAddendumBuilder;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;

class IssueConstantSearchRequestAppender
implements SearchRequestAddendumBuilder.AddendumCallback<IssueConstant>,
SearchRequestAppender<IssueConstant> {
    private final String issueFieldConstant;

    public IssueConstantSearchRequestAppender(String issueFieldConstant) {
        this.issueFieldConstant = Assertions.notNull(issueFieldConstant);
    }

    @Override
    public void appendNonNullItem(IssueConstant value, JqlClauseBuilder clauseBuilder) {
        clauseBuilder.addStringCondition(this.issueFieldConstant, Operator.EQUALS, value.getName());
    }

    @Override
    public void appendNullItem(JqlClauseBuilder clauseBuilder) {
        clauseBuilder.addEmptyCondition(this.issueFieldConstant);
    }

    @Override
    public SearchRequest appendInclusiveSingleValueClause(IssueConstant value, SearchRequest searchRequest) {
        return SearchRequestAddendumBuilder.appendAndClause(value, searchRequest, this);
    }

    @Override
    public SearchRequest appendExclusiveMultiValueClause(Iterable<? extends IssueConstant> values, SearchRequest searchRequest) {
        return SearchRequestAddendumBuilder.appendAndNotClauses(values, searchRequest, this);
    }
}

