/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.action.RequestSourceType;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
@EventName(value="jira.administration.projectdetails.updated")
@PublicApi
public class ProjectUpdatedDetailedChangesEvent
extends AbstractEvent {
    private final boolean isProjectNameChanged;
    private final boolean isProjectUrlChanged;
    private final boolean isProjectDescriptionChanged;
    private boolean isProjectAvatarChanged;
    private String projectAvatarChangedTo;
    private String requestSourceType;

    @Internal
    public ProjectUpdatedDetailedChangesEvent(Project oldProject, Project newProject, RequestSourceType requestSourceType) {
        this.isProjectNameChanged = !StringUtils.equals((String)oldProject.getName(), (String)newProject.getName());
        this.isProjectUrlChanged = !StringUtils.equals((String)oldProject.getUrl(), (String)newProject.getUrl());
        this.isProjectDescriptionChanged = !StringUtils.equals((String)oldProject.getDescription(), (String)newProject.getDescription());
        Avatar newAvatar = newProject.getAvatar();
        if (oldProject.getAvatar() != null && newAvatar != null && !oldProject.getAvatar().getId().equals(newAvatar.getId())) {
            this.isProjectAvatarChanged = true;
            this.projectAvatarChangedTo = newAvatar.isSystemAvatar() ? newAvatar.getId().toString() : "custom";
        }
        this.requestSourceType = requestSourceType.getType();
    }

    public boolean getIsProjectNameChanged() {
        return this.isProjectNameChanged;
    }

    public boolean getIsProjectUrlChanged() {
        return this.isProjectUrlChanged;
    }

    public boolean getIsProjectDescriptionChanged() {
        return this.isProjectDescriptionChanged;
    }

    public boolean getIsProjectAvatarChanged() {
        return this.isProjectAvatarChanged;
    }

    public String getProjectAvatarChangedTo() {
        return this.projectAvatarChangedTo;
    }

    public String getRequestSourceType() {
        return this.requestSourceType;
    }
}

