/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.annotations.ExperimentalApi;
import javax.annotation.Nullable;

@ExperimentalApi
public enum AuditingCategory {
    AUDITING("auditing", "jira.auditing.category"),
    USER_MANAGEMENT("user management", "jira.auditing.category.usermanagement"),
    GROUP_MANAGEMENT("group management", "jira.auditing.category.groupmanagement"),
    PERMISSIONS("permissions", "jira.auditing.category.permissions"),
    WORKFLOWS("workflows", "jira.auditing.category.workflows"),
    NOTIFICATIONS("notifications", "jira.auditing.category.notifications"),
    FIELDS("fields", "jira.auditing.category.fields"),
    PROJECTS("projects", "jira.auditing.category.projects"),
    SYSTEM("system", "jira.auditing.category.system"),
    MIGRATION("migration", "jira.auditing.category.migration"),
    APPLICATIONS("applications", "jira.auditing.category.applications"),
    USER_DATA_TRANSFER("user data transfer", "jira.auditing.category.userdatatransfer");

    private final String id;
    private final String nameI18nKey;

    private AuditingCategory(String id, String nameI18nKey) {
        this.id = id;
        this.nameI18nKey = nameI18nKey;
    }

    public String getId() {
        return this.id;
    }

    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    @Nullable
    public static AuditingCategory getCategoryById(String categoryId) {
        for (AuditingCategory category : AuditingCategory.values()) {
            if (!category.getId().equals(categoryId)) continue;
            return category;
        }
        return null;
    }

    @Nullable
    public static AuditingCategory getCategoryByIdOrName(String idOrName) {
        for (AuditingCategory category : AuditingCategory.values()) {
            if (!category.getId().equals(idOrName)) continue;
            return category;
        }
        for (AuditingCategory category : AuditingCategory.values()) {
            if (!category.name().equals(idOrName)) continue;
            return category;
        }
        return null;
    }
}

