/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.WarningCollection;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleWarningCollection
implements WarningCollection,
Serializable {
    private static final long serialVersionUID = 1667504127494141328L;
    private final List<String> warnings = new LinkedList<String>();

    public SimpleWarningCollection() {
    }

    public SimpleWarningCollection(@Nonnull WarningCollection warningsCollection) {
        this.warnings.addAll(Objects.requireNonNull(warningsCollection.getWarnings()));
    }

    @Override
    public void addWarning(String warningMessage) {
        this.warnings.add(warningMessage);
    }

    @Override
    public Collection<String> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }

    @Override
    public boolean hasAnyWarnings() {
        return !this.warnings.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleWarningCollection that = (SimpleWarningCollection)o;
        return !(this.warnings == null ? that.warnings != null : !this.warnings.equals(that.warnings));
    }

    public int hashCode() {
        return this.warnings != null ? this.warnings.hashCode() : 0;
    }
}

