/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.NumberIndexValueConverter;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.IndexValuesValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;

public class NumberCustomFieldValidator
implements ClauseValidator {
    private final IndexValuesValidator indexValuesValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlOperandResolver jqlOperandResolver;
    private final I18nHelper.BeanFactory beanFactory;

    public NumberCustomFieldValidator(JqlOperandResolver jqlOperandResolver, NumberIndexValueConverter indexValueConverter) {
        this(jqlOperandResolver, indexValueConverter, ComponentAccessor.getI18nHelperFactory());
    }

    public NumberCustomFieldValidator(JqlOperandResolver jqlOperandResolver, NumberIndexValueConverter indexValueConverter, I18nHelper.BeanFactory beanFactory) {
        this.beanFactory = Assertions.notNull("beanFactory", beanFactory);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
        this.indexValuesValidator = this.getIndexValuesValidator(indexValueConverter);
    }

    @Override
    public MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!errors.hasAnyErrors()) {
            errors = this.indexValuesValidator.validate(searcher, terminalClause);
        }
        return errors;
    }

    IndexValuesValidator getIndexValuesValidator(NumberIndexValueConverter indexValueConverter) {
        return new IndexValuesValidator(this.jqlOperandResolver, indexValueConverter){

            @Override
            void addError(MessageSet messageSet, ApplicationUser searcher, TerminalClause terminalClause, QueryLiteral literal) {
                String fieldName = terminalClause.getName();
                if (NumberCustomFieldValidator.this.jqlOperandResolver.isFunctionOperand(literal.getSourceOperand())) {
                    messageSet.addErrorMessage(NumberCustomFieldValidator.this.getI18n(searcher).getText("jira.jql.clause.invalid.number.value.function", literal.getSourceOperand().getName(), fieldName));
                } else {
                    messageSet.addErrorMessage(NumberCustomFieldValidator.this.getI18n(searcher).getText("jira.jql.clause.invalid.number.value", fieldName, literal.asString()));
                }
            }
        };
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, OperatorClasses.RELATIONAL_ONLY_OPERATORS);
    }

    I18nHelper getI18n(ApplicationUser user) {
        return this.beanFactory.getInstance(user);
    }
}

