/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.security.roles.ProjectRole;

@PublicApi
public class ProjectRoleImpl
implements ProjectRole {
    private static final Long ZERO = 0L;
    private final Long id;
    private final String name;
    private final String description;

    public ProjectRoleImpl(String name, String description) {
        this.id = ZERO;
        this.name = name;
        this.description = description;
    }

    public ProjectRoleImpl(Long id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectRoleImpl that = (ProjectRoleImpl)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return this.name;
    }

    public static class Builder {
        private Long id;
        private String name;
        private String description;

        private Builder(Long id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public static Builder from(ProjectRole role) {
            return new Builder(role.getId(), role.getName(), role.getDescription());
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public ProjectRole build() {
            return new ProjectRoleImpl(this.id, this.name, this.description);
        }
    }
}

