/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(LocalDateIndexer.class);

    public LocalDateIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Date || value == null) {
            Date date = (Date)value;
            try {
                LocalDate localDate = LocalDateFactory.from(date);
                if (date != null) {
                    doc.add((Fieldable)new Field(this.getDocumentFieldId(), LuceneUtils.localDateToString(localDate), Field.Store.YES, indexType));
                }
                if (indexType == Field.Index.NOT_ANALYZED_NO_NORMS) {
                    doc.add((Fieldable)new Field("sort_" + this.getDocumentFieldId(), LuceneUtils.localDateToString(localDate), Field.Store.NO, indexType));
                }
            }
            catch (RuntimeException ex) {
                log.warn("Unable to index custom date field '" + this.customField.getName() + "(" + this.customField.getId() + ") with value: " + value);
            }
        }
    }
}

