/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserUtils {
    public static final String USER_AGENT_HEADER = "USER-AGENT";
    private static final Logger log = LoggerFactory.getLogger(BrowserUtils.class);

    public static String getModifierKey() {
        try {
            HttpServletRequest request = ExecutingHttpRequest.get();
            if (request != null) {
                return BrowserUtils.getModifierKey(request.getHeader(USER_AGENT_HEADER));
            }
        }
        catch (RuntimeException rte) {
            log.warn(rte.getMessage(), (Throwable)rte);
        }
        return "Alt";
    }

    static String getModifierKey(String userAgent) {
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        UserAgentUtil.UserAgent userAgentInfo = userAgentUtil.getUserAgentInfo(userAgent);
        UserAgentUtil.Browser browser = userAgentInfo.getBrowser();
        UserAgentUtil.OperatingSystem operatingSystem = userAgentInfo.getOperatingSystem();
        switch (browser.getBrowserFamily()) {
            case MSIE: 
            case IE: {
                return "Alt";
            }
            case FIREFOX: 
            case GECKO: {
                if (operatingSystem.getOperatingSystemFamily() == UserAgentUtil.OperatingSystem.OperatingSystemFamily.WINDOWS || operatingSystem.getOperatingSystemFamily() == UserAgentUtil.OperatingSystem.OperatingSystemFamily.LINUX) {
                    if (browser.getBrowserMajorVersion().compareTo(UserAgentUtil.BrowserMajorVersion.FIREFOX2) < 0) {
                        return "Alt";
                    }
                    return "Alt+Shift";
                }
                if (operatingSystem.getOperatingSystemFamily() != UserAgentUtil.OperatingSystem.OperatingSystemFamily.MAC) break;
                return "Ctrl";
            }
            case OPERA: {
                return "Shift+Esc";
            }
            case SAFARI: {
                if (operatingSystem.getOperatingSystemFamily() == UserAgentUtil.OperatingSystem.OperatingSystemFamily.WINDOWS) {
                    return "Alt";
                }
                return "Ctrl+Alt";
            }
            case CHROME: {
                if (operatingSystem.getOperatingSystemFamily() == UserAgentUtil.OperatingSystem.OperatingSystemFamily.WINDOWS) {
                    return "Alt";
                }
                if (operatingSystem.getOperatingSystemFamily() != UserAgentUtil.OperatingSystem.OperatingSystemFamily.MAC) break;
                return "Ctrl+Alt";
            }
        }
        return "Alt";
    }

    public static boolean isIe456Or7(String userAgent) {
        if (StringUtils.isBlank((String)userAgent)) {
            return false;
        }
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        UserAgentUtil.UserAgent userAgentInfo = userAgentUtil.getUserAgentInfo(userAgent);
        UserAgentUtil.Browser browser = userAgentInfo.getBrowser();
        return browser.getBrowserFamily() == UserAgentUtil.BrowserFamily.MSIE && browser.getBrowserMajorVersion().compareTo(UserAgentUtil.BrowserMajorVersion.MSIE8) < 0;
    }

    public static boolean isFilterBasedPngOpacity(String userAgent) {
        if (StringUtils.isBlank((String)userAgent)) {
            return false;
        }
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        UserAgentUtil.UserAgent userAgentInfo = userAgentUtil.getUserAgentInfo(userAgent);
        return userAgentInfo.getOperatingSystem().getOperatingSystemFamily() == UserAgentUtil.OperatingSystem.OperatingSystemFamily.WINDOWS && (userAgentInfo.getBrowser().getBrowserFamily() == UserAgentUtil.BrowserFamily.MSIE || userAgentInfo.getBrowser().getBrowserFamily() == UserAgentUtil.BrowserFamily.IE);
    }
}

