/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.customfield;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;

@Internal
public class TextLengthValidatingCustomFieldImporter
implements ProjectCustomFieldImporter {
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;

    public TextLengthValidatingCustomFieldImporter(TextFieldCharacterLengthValidator textFieldCharacterLengthValidator) {
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
    }

    @Override
    public MessageSet canMapImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig, I18nHelper i18n) {
        int length = customFieldValue.getValue().length();
        if (this.textFieldCharacterLengthValidator.isTextTooLong(length)) {
            MessageSetImpl messageSet = new MessageSetImpl();
            messageSet.addErrorMessage(i18n.getText("admin.errors.project.import.field.text.too.long", String.valueOf(length), String.valueOf(this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters())));
            return messageSet;
        }
        return null;
    }

    @Override
    public ProjectCustomFieldImporter.MappedCustomFieldValue getMappedImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig) {
        return new ProjectCustomFieldImporter.MappedCustomFieldValue(customFieldValue.getValue());
    }
}

