/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.preferences;

import com.atlassian.annotations.Internal;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.google.common.base.Objects;
import com.opensymphony.module.propertyset.PropertySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public class JiraUserPreferences
implements ExtendedPreferences {
    private static final String ANONYMOUS_USER = "You cannot set properties on a null user.";
    private final String userKey;
    private final PropertySet propertySet;

    JiraUserPreferences(String userKey, PropertySet propertySet) {
        this.userKey = userKey;
        this.propertySet = propertySet;
    }

    @Deprecated
    public JiraUserPreferences() {
        this(null, null);
    }

    @Deprecated
    public JiraUserPreferences(PropertySet userPs) {
        this(null, userPs);
    }

    public long getLong(String key) {
        if (this.propertySet != null && this.propertySet.exists(key)) {
            return this.propertySet.getLong(key);
        }
        return Long.parseLong(this.getApplicationProperties().getDefaultBackedString(key));
    }

    public String getString(String key) {
        if (this.propertySet != null && this.propertySet.exists(key)) {
            return this.propertySet.getString(key);
        }
        return this.getApplicationProperties().getDefaultBackedString(key);
    }

    @Override
    public String getText(String key) {
        if (this.propertySet != null && this.propertySet.exists(key)) {
            return this.propertySet.getText(key);
        }
        return this.getApplicationProperties().getDefaultBackedText(key);
    }

    public boolean getBoolean(String key) {
        if (this.propertySet != null && this.propertySet.exists(key)) {
            return this.propertySet.getBoolean(key);
        }
        return this.getApplicationProperties().getOption(key);
    }

    public void setLong(String key, long value) throws AtlassianCoreException {
        if (this.propertySet == null) {
            throw new AtlassianCoreException(ANONYMOUS_USER);
        }
        this.propertySet.setLong(key, value);
    }

    public void setString(String key, String value) throws AtlassianCoreException {
        if (this.propertySet == null) {
            throw new AtlassianCoreException(ANONYMOUS_USER);
        }
        this.propertySet.setString(key, value);
    }

    @Override
    public void setText(String key, String value) throws AtlassianCoreException {
        if (this.propertySet == null) {
            throw new AtlassianCoreException(ANONYMOUS_USER);
        }
        this.propertySet.setText(key, value);
    }

    public void setBoolean(String key, boolean value) throws AtlassianCoreException {
        if (this.propertySet == null) {
            throw new AtlassianCoreException(ANONYMOUS_USER);
        }
        this.propertySet.setBoolean(key, value);
    }

    public void remove(String key) throws AtlassianCoreException {
        if (this.propertySet == null) {
            throw new AtlassianCoreException(ANONYMOUS_USER);
        }
        if (!this.propertySet.exists(key)) {
            throw new AtlassianCoreException("The property with key '" + key + "' does not exist.");
        }
        this.propertySet.remove(key);
    }

    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    @Override
    public String getUserKey() {
        return this.userKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ExtendedPreferences && this.equals((ExtendedPreferences)o);
    }

    private boolean equals(@Nonnull ExtendedPreferences other) {
        return Objects.equal((Object)this.userKey, (Object)other.getUserKey());
    }

    @Override
    public int hashCode() {
        return this.userKey != null ? this.userKey.hashCode() : 0;
    }

    @Override
    public boolean containsValue(String key) {
        return this.propertySet.exists(key);
    }

    @Nullable
    private static PropertySet getPropertySet(ApplicationUser user) {
        if (user == null) {
            return null;
        }
        return ComponentAccessor.getUserPropertyManager().getPropertySet(user);
    }
}

