/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.jql.validator.NumberOfArgumentsValidator;
import com.atlassian.jira.plugin.jql.function.JqlFunction;
import com.atlassian.jira.plugin.jql.function.JqlFunctionModuleDescriptor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.FunctionOperand;

@PublicSpi
public abstract class AbstractJqlFunction
implements JqlFunction {
    private volatile JqlFunctionModuleDescriptor moduleDescriptor;

    @Override
    public void init(JqlFunctionModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = Assertions.notNull("moduleDescriptor", moduleDescriptor);
    }

    public JqlFunctionModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    protected MessageSet validateNumberOfArgs(FunctionOperand operand, int expected) {
        return new NumberOfArgumentsValidator(expected, this.getI18n()).validate(operand);
    }

    @Override
    public String getFunctionName() {
        return this.moduleDescriptor.getFunctionName();
    }

    @Override
    public boolean isList() {
        return this.moduleDescriptor.isList();
    }

    protected I18nHelper getI18n() {
        return this.moduleDescriptor.getI18nBean();
    }
}

