/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.util.UtilDateTime;

@PublicApi
public class CreateAttachmentParamsBean {
    private final File file;
    private final String filename;
    private final String contentType;
    @Nullable
    private final ApplicationUser author;
    private final Issue issue;
    private final Boolean zip;
    private final Boolean thumbnailable;
    private final Map<String, Object> attachmentProperties;
    private final Date createdTime;
    private final Boolean copySourceFile;

    public CreateAttachmentParamsBean(File file, String filename, String contentType, @Nullable ApplicationUser author, Issue issue, Boolean zip, Boolean thumbnailable, Map<String, Object> attachmentProperties, Date createdTime, Boolean copySourceFile) {
        this.file = file;
        this.filename = filename;
        this.contentType = contentType;
        this.author = author;
        this.issue = issue;
        this.zip = zip;
        this.thumbnailable = thumbnailable;
        this.attachmentProperties = attachmentProperties;
        this.createdTime = createdTime;
        this.copySourceFile = copySourceFile;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public ApplicationUser getAuthor() {
        return this.author;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public Boolean getZip() {
        return this.zip;
    }

    public Boolean getThumbnailable() {
        return this.thumbnailable;
    }

    public Map<String, Object> getAttachmentProperties() {
        return this.attachmentProperties;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Boolean getCopySourceFile() {
        return this.copySourceFile;
    }

    public static class Builder {
        private File file;
        private String filename;
        private String contentType;
        @Nullable
        private ApplicationUser author;
        private Issue issue;
        private Boolean zip;
        private Boolean thumbnailable;
        private Map<String, Object> attachmentProperties;
        private Date createdTime = UtilDateTime.nowTimestamp();
        private Boolean copySourceFile = false;

        public Builder() {
        }

        public Builder(File file, String filename, String contentType, @Nullable ApplicationUser author, Issue issue) {
            this.file = file;
            this.filename = filename;
            this.contentType = contentType;
            this.author = author;
            this.issue = issue;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder author(@Nullable ApplicationUser author) {
            this.author = author;
            return this;
        }

        public Builder issue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public Builder zip(Boolean zip) {
            this.zip = zip;
            return this;
        }

        public Builder thumbnailable(Boolean thumbnailable) {
            this.thumbnailable = thumbnailable;
            return this;
        }

        public Builder attachmentProperties(Map<String, Object> attachmentProperties) {
            this.attachmentProperties = attachmentProperties;
            return this;
        }

        public Builder createdTime(Date createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder copySourceFile(Boolean copySourceFile) {
            this.copySourceFile = copySourceFile;
            return this;
        }

        public CreateAttachmentParamsBean build() {
            Preconditions.checkNotNull((Object)this.file);
            Preconditions.checkNotNull((Object)this.filename);
            Preconditions.checkNotNull((Object)this.issue);
            return new CreateAttachmentParamsBean(this.file, this.filename, this.contentType, this.author, this.issue, this.zip, this.thumbnailable, this.attachmentProperties, this.createdTime, this.copySourceFile);
        }
    }
}

