/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.Collection;
import java.util.Map;

public interface BulkMoveHelper {
    public Map<Long, DistinctValueResult> getDistinctValuesForMove(BulkEditBean var1, OrderableField var2, Function<Issue, Collection<Object>> var3, Function<Object, String> var4);

    public boolean needsSelection(DistinctValueResult var1, Long var2, String var3);

    public static class DistinctValueResult {
        private final String valueName;
        private final String projectName;
        private final Long previouslySelectedValue;
        private final boolean isPreviousValueSpecified;

        public DistinctValueResult() {
            this("", "", null, false);
        }

        public DistinctValueResult(String valueName, String projectName, Long previouslySelectedValue, boolean isPreviousValueSpecified) {
            this.valueName = valueName;
            this.projectName = projectName;
            this.previouslySelectedValue = previouslySelectedValue;
            this.isPreviousValueSpecified = isPreviousValueSpecified;
        }

        public String getValueName() {
            return this.valueName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public Long getPreviouslySelectedValue() {
            return this.previouslySelectedValue;
        }

        public boolean isPreviousValueSpecified() {
            return this.isPreviousValueSpecified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DistinctValueResult that = (DistinctValueResult)o;
            if (this.isPreviousValueSpecified != that.isPreviousValueSpecified) {
                return false;
            }
            if (this.previouslySelectedValue != null ? !this.previouslySelectedValue.equals(that.previouslySelectedValue) : that.previouslySelectedValue != null) {
                return false;
            }
            if (this.projectName != null ? !this.projectName.equals(that.projectName) : that.projectName != null) {
                return false;
            }
            return !(this.valueName != null ? !this.valueName.equals(that.valueName) : that.valueName != null);
        }

        public int hashCode() {
            int result = this.valueName != null ? this.valueName.hashCode() : 0;
            result = 31 * result + (this.projectName != null ? this.projectName.hashCode() : 0);
            result = 31 * result + (this.previouslySelectedValue != null ? this.previouslySelectedValue.hashCode() : 0);
            result = 31 * result + (this.isPreviousValueSpecified ? 1 : 0);
            return result;
        }
    }
}

