/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.annotations.Internal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LnFDefaultColorProvider;
import com.atlassian.jira.config.properties.LogoProvider;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.util.HashBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

public class LookAndFeelBean {
    private final ApplicationProperties applicationProperties;
    private final LnFDefaultColorProvider lnFDefaultColorProvider;
    private final LogoProvider logoProvider;

    LookAndFeelBean(ApplicationProperties applicationProperties, LnFDefaultColorProvider lnFDefaultColorProvider, LogoProvider logoProvider) {
        this.applicationProperties = applicationProperties;
        this.lnFDefaultColorProvider = lnFDefaultColorProvider;
        this.logoProvider = logoProvider;
    }

    @Deprecated
    public static LookAndFeelBean getInstance(ApplicationProperties ap) {
        return new LookAndFeelBean(ap, ComponentAccessor.getComponent(LnFDefaultColorProvider.class), ComponentAccessor.getComponent(LogoProvider.class));
    }

    @Deprecated
    public static LookAndFeelBean getInstance(ApplicationProperties ap, LnFDefaultColorProvider lnFDefaultColorProvider) {
        return new LookAndFeelBean(ap, lnFDefaultColorProvider, ComponentAccessor.getComponent(LogoProvider.class));
    }

    public static LookAndFeelBean getInstance(ApplicationProperties ap, LnFDefaultColorProvider lnFDefaultColorProvider, LogoProvider logoProvider) {
        return new LookAndFeelBean(ap, lnFDefaultColorProvider, logoProvider);
    }

    @Deprecated
    public boolean isCommonHeader() {
        return true;
    }

    @Deprecated
    public String stripHash(String colour) {
        if (StringUtils.isNotBlank((CharSequence)colour) && colour.startsWith("#")) {
            return colour.substring(1, colour.length());
        }
        return colour;
    }

    private void setValue(LnF config, String value) {
        this.setValue(config.propertyKey, value);
    }

    private void setValue(String propertyKey, String value) {
        this.applicationProperties.setString(propertyKey, value);
        this.updateSettingsHash();
    }

    @Deprecated
    public void updateVersion(long oldVersion) {
        this.updateSettingsHash();
    }

    @Deprecated
    public long getVersion() {
        return 1L;
    }

    @Nonnull
    public String updateSettingsHash() {
        String settingsHash = this.calculateHash();
        this.applicationProperties.setString("jira.webresource.flushcounter", settingsHash);
        EventPublisher publisher = ComponentAccessor.getComponent(EventPublisher.class);
        if (publisher != null) {
            publisher.publish((Object)new LookAndFeelChangedEvent());
        }
        return settingsHash;
    }

    @Nonnull
    public String getSettingsHash() {
        String editVersion = this.applicationProperties.getDefaultBackedString("jira.webresource.flushcounter");
        return StringUtils.isEmpty((CharSequence)editVersion) ? this.updateSettingsHash() : editVersion;
    }

    @Nonnull
    private String calculateHash() {
        HashBuilder md5hash = new HashBuilder();
        for (LnF lnF : LnF.values()) {
            md5hash.add(lnF.propertyKey);
            md5hash.add("=");
            md5hash.add(StringUtils.defaultString((String)this.getValue(lnF), (String)""));
            md5hash.add("|");
        }
        for (LnF lnF : Color.values()) {
            if (lnF.equals(Color.color8)) continue;
            md5hash.add("jira.lf.gadget.");
            md5hash.add(lnF.name());
            md5hash.add("=");
            md5hash.add(StringUtils.defaultString((String)this.getGadgetChromeColor(lnF.name()), (String)""));
            md5hash.add("|");
        }
        return md5hash.build();
    }

    public String getLogoUrl() {
        return this.logoProvider.getLogo();
    }

    public void setLogoUrl(String logoUrl) {
        this.setValue(LnF.LogoUrl, logoUrl);
    }

    public String getAbsoluteLogoUrl() {
        String jiraLogo = this.getLogoUrl();
        if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
            jiraLogo = ComponentAccessor.getComponent(WebResourceUrlProvider.class).getStaticResourcePrefix(UrlMode.AUTO) + jiraLogo;
        }
        return jiraLogo;
    }

    public String getLogoWidth() {
        return this.getValue(LnF.LogoWidth);
    }

    public void setLogoWidth(String logoWidth) {
        this.setValue(LnF.LogoWidth, logoWidth);
    }

    public String getLogoPixelWidth() {
        return this.getLogoWidth() + "px";
    }

    public String getLogoHeight() {
        return this.getValue(LnF.LogoHeight);
    }

    public void setLogoHeight(String logoHeight) {
        this.setValue(LnF.LogoHeight, logoHeight);
    }

    public String getLogoPixelHeight() {
        return this.getLogoHeight() + "px";
    }

    public String getFaviconUrl() {
        return this.getValue(LnF.FaviconUrl);
    }

    public void setFaviconUrl(String faviconUrl) {
        this.setValue(LnF.FaviconUrl, faviconUrl);
    }

    public String getFaviconWidth() {
        return "16";
    }

    public String getFaviconHeight() {
        return "16";
    }

    public String getFaviconHiResUrl() {
        return this.logoProvider.getFavicon();
    }

    public void setFaviconHiResUrl(String faviconUrl) {
        this.setValue(LnF.FaviconHiResUrl, faviconUrl);
    }

    public String getFaviconHiResWidth() {
        return "32";
    }

    public String getFaviconHiResHeight() {
        return "32";
    }

    public String getTopBackgroundColour() {
        return this.getValue(LnF.TopBackgroundColor);
    }

    public void setTopBackgroundColour(String topBackgroundColour) {
        this.setValue(LnF.TopBackgroundColor, topBackgroundColour);
    }

    public String getTopTxtColour() {
        return this.getValue(LnF.TopTxtColour);
    }

    public void setTopTxtColour(String topTxtColour) {
        this.setValue(LnF.TopTxtColour, topTxtColour);
    }

    public String getTopHighlightColor() {
        return this.getValue(LnF.TopHighlightColor);
    }

    public void setTopHighlightColor(String newValue) {
        this.setValue(LnF.TopHighlightColor, newValue);
    }

    @Nullable
    protected String getValue(@Nonnull LnF config) {
        return this.getValue(config.propertyKey);
    }

    private String getValue(@Nonnull String propertyKey) {
        return this.lnFDefaultColorProvider.getValue(propertyKey).map(defaultValue -> this.getDefaultBackedString(propertyKey, (String)defaultValue)).orElseGet(() -> this.getDefaultBackedString(propertyKey));
    }

    public String getTopTextHighlightColor() {
        return this.getValue(LnF.TopTextHighlightColor);
    }

    public void setTopTextHighlightColor(String newValue) {
        this.setValue(LnF.TopTextHighlightColor, newValue);
    }

    public String getTopSeparatorBackgroundColor() {
        return this.getValue(LnF.TopSeparatorBackgroundColor);
    }

    public void setTopSeparatorBackgroundColor(String newValue) {
        this.setValue(LnF.TopSeparatorBackgroundColor, newValue);
    }

    public String getMenuTxtColour() {
        return this.getValue(LnF.MenuTxtColour);
    }

    public void setMenuTxtColour(String menuTxtColour) {
        this.setValue(LnF.MenuTxtColour, menuTxtColour);
    }

    public String getMenuBackgroundColour() {
        return this.getValue(LnF.MenuBackgroundColour);
    }

    public void setMenuBackgroundColour(String menuBackgroundColour) {
        this.setValue(LnF.MenuBackgroundColour, menuBackgroundColour);
    }

    public String getMenuSeparatorColour() {
        return this.getValue(LnF.MenuSeparatorColour);
    }

    public void setMenuSeparatorColour(String menuSeparatorColour) {
        this.setValue(LnF.MenuSeparatorColour, menuSeparatorColour);
    }

    public String getTextHeadingColour() {
        return this.getValue(LnF.TextHeadingColour);
    }

    public void setTextHeadingColour(String textHeadingColour) {
        this.setValue(LnF.TextHeadingColour, textHeadingColour);
    }

    public String getTextLinkColour() {
        return this.getValue(LnF.TextLinkColour);
    }

    public void setTextLinkColour(String textLinkColour) {
        this.setValue(LnF.TextLinkColour, textLinkColour);
    }

    public String getTextActiveLinkColour() {
        return this.getValue(LnF.TextActiveLinkColour);
    }

    public void setTextActiveLinkColour(String textActiveLinkColour) {
        this.setValue(LnF.TextActiveLinkColour, textActiveLinkColour);
    }

    public String getHeroButtonTextColour() {
        return this.getValue(LnF.HeroButtonTextColour);
    }

    public void setHeroButtonTextColour(String heroButtonTextColour) {
        this.setValue(LnF.HeroButtonTextColour, heroButtonTextColour);
    }

    public String getHeroButtonBaseBGColour() {
        return this.getValue(LnF.HeroButtonBaseBGColour);
    }

    public void setHeroButtonBaseBGColour(String heroButtonBaseBGColour) {
        this.setValue(LnF.HeroButtonBaseBGColour, heroButtonBaseBGColour);
    }

    public String getGadgetChromeColor(String id) {
        return this.getValue("jira.lf.gadget." + id);
    }

    public void setGadgetChromeColor(String id, String gadgetChromeColor) {
        this.setValue("jira.lf.gadget." + id, gadgetChromeColor);
    }

    public String getApplicationID() {
        return this.applicationProperties.getDefaultBackedString("jira.lf.application.id");
    }

    public String getDefaultBackedString(@Nonnull String key, @Nullable String defaultValue) {
        String value = this.applicationProperties.getString(key);
        return value == null ? defaultValue : value;
    }

    public String getDefaultBackedString(@Nonnull String key) {
        String propertyValue = this.applicationProperties.getString(key);
        return propertyValue != null ? propertyValue : this.applicationProperties.getDefaultBackedString(key);
    }

    public static class DefaultFaviconDimensions {
        public static final String FAVICON_DIMENSION = "16";
        public static final String FAVICON_HIRES_DIMENSION = "32";

        private DefaultFaviconDimensions() {
        }
    }

    public static final class DefaultCommonColours {
        public static final String TOP_HIGHLIGHTCOLOUR = "#033681";
        public static final String TOP_SEPARATOR_BGCOLOUR = "#2e3d54";
        public static final String TOP_BGCOLOUR = "#0747a6";
        public static final String HERO_BUTTON_TXTCOLOUR = "#ffffff";
        public static final String HERO_BUTTON_BASEBGCOLOUR = "#3b7fc4";

        private DefaultCommonColours() {
        }
    }

    public static final class DefaultColours {
        public static final String TOP_HIGHLIGHTCOLOUR = "#033681";
        public static final String TOP_TEXTHIGHLIGHTCOLOUR = "#deebff";
        public static final String TOP_SEPARATOR_BGCOLOUR = "#2e3d54";
        public static final String TOP_BGCOLOUR = "#0747a6";
        public static final String TOP_TEXTCOLOUR = "#deebff";
        public static final String MENU_BGCOLOUR = "#ebecf0";
        public static final String MENU_TEXTCOLOUR = "#42526e";
        public static final String MENU_SEPARATOR = "#dfe1e6";
        public static final String TEXT_LINKCOLOR = "#0052cc";
        public static final String TEXT_ACTIVELINKCOLOR = "#0065ff";
        public static final String TEXT_HEADINGCOLOR = "#172b4d";

        private DefaultColours() {
        }
    }

    public static class LookAndFeelChangedEvent {
    }

    @ParametersAreNonnullByDefault
    @Internal
    static enum LnF {
        TopBackgroundColor("jira.lf.top.bgcolour", "#0747a6"),
        TopHighlightColor("jira.lf.top.hilightcolour", "#033681"),
        TopTxtColour("jira.lf.top.textcolour", "#deebff"),
        TopTextHighlightColor("jira.lf.top.texthilightcolour", "#deebff"),
        TopSeparatorBackgroundColor("jira.lf.top.separator.bgcolor", "#2e3d54"),
        MenuTxtColour("jira.lf.menu.textcolour", "#42526e"),
        MenuBackgroundColour("jira.lf.menu.bgcolour", "#ebecf0"),
        MenuSeparatorColour("jira.lf.menu.separator", "#dfe1e6"),
        TextHeadingColour("jira.lf.text.headingcolour", "#172b4d"),
        TextLinkColour("jira.lf.text.linkcolour", "#0052cc"),
        TextActiveLinkColour("jira.lf.text.activelinkcolour", "#0065ff"),
        HeroButtonTextColour("jira.lf.hero.button.text.colour", "#ffffff"),
        HeroButtonBaseBGColour("jira.lf.hero.button.base.bg.colour", "#3b7fc4"),
        FaviconHiResUrl("jira.lf.favicon.hires.url", null),
        FaviconUrl("jira.lf.favicon.url", null),
        LogoHeight("jira.lf.logo.height", null),
        LogoWidth("jira.lf.logo.width", null),
        LogoUrl("jira.lf.logo.url", null);

        @Nullable
        private final String defaultValue;
        private final String propertyKey;

        private LnF(String propertyKey, String defaultValue) {
            this.defaultValue = defaultValue;
            this.propertyKey = propertyKey;
        }
    }
}

