/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.version;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.version.DeleteVersionWithReplacementsParameterBuilder;
import com.atlassian.jira.bc.project.version.RemoveVersionAction;
import com.atlassian.jira.bc.project.version.VersionBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.CustomFieldWithVersionUsage;
import com.atlassian.jira.project.version.DeleteVersionWithCustomFieldParameters;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.OrderByRequest;
import com.atlassian.jira.util.OrderByRequests;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface VersionService {
    public static final VersionAction REMOVE = new RemoveVersionAction();

    @Deprecated
    public ErrorCollection validateVersionDetails(ApplicationUser var1, Version var2, String var3, String var4);

    @Deprecated
    public ServiceOutcome<Version> setVersionDetails(ApplicationUser var1, Version var2, String var3, String var4);

    @Deprecated
    public ServiceOutcome<Version> setReleaseDate(ApplicationUser var1, Version var2, Date var3);

    @Deprecated
    public ServiceOutcome<Version> validateReleaseDate(ApplicationUser var1, Version var2, String var3);

    @Deprecated
    public ServiceOutcome<Version> setReleaseDate(ApplicationUser var1, Version var2, String var3);

    public ValidationResult validateDelete(JiraServiceContext var1, Long var2, VersionAction var3, VersionAction var4);

    public void delete(JiraServiceContext var1, ValidationResult var2);

    public ValidationResult validateMerge(JiraServiceContext var1, Long var2, Long var3);

    public void merge(JiraServiceContext var1, ValidationResult var2);

    public VersionResult getVersionById(ApplicationUser var1, Project var2, Long var3);

    public VersionResult getVersionById(ApplicationUser var1, Long var2);

    @Nonnull
    public VersionResult getVersionByProjectAndName(@Nullable ApplicationUser var1, @Nonnull Project var2, @Nonnull String var3);

    @Nonnull
    public VersionsResult getVersionsByProject(@Nullable ApplicationUser var1, @Nonnull Project var2);

    @Nonnull
    public ServiceOutcome<Page<Version>> getVersionsByProject(@Nullable ApplicationUser var1, @Nonnull Project var2, @Nonnull PageRequest var3);

    @Nonnull
    public ServiceOutcome<Page<Version>> getVersionsByProject(@Nullable ApplicationUser var1, @Nonnull Project var2, @Nonnull PageRequest var3, @Nullable OrderByRequest<VersionExtractableField> var4);

    @Deprecated
    public CreateVersionValidationResult validateCreateVersion(ApplicationUser var1, Project var2, String var3, String var4, String var5, Long var6);

    @Deprecated
    public CreateVersionValidationResult validateCreateVersion(ApplicationUser var1, Project var2, String var3, Date var4, String var5, Long var6);

    @Deprecated
    public Version createVersion(ApplicationUser var1, CreateVersionValidationResult var2);

    @Nonnull
    public ReleaseVersionValidationResult validateReleaseVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nullable Date var3);

    @Nonnull
    public ReleaseVersionValidationResult validateReleaseVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nonnull String var3);

    @Nonnull
    public ReleaseVersionValidationResult validateUnreleaseVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nullable Date var3);

    @Nonnull
    public ReleaseVersionValidationResult validateUnreleaseVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nonnull String var3);

    public Version releaseVersion(ReleaseVersionValidationResult var1);

    public void moveUnreleasedToNewVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nonnull Version var3);

    public Version unreleaseVersion(ReleaseVersionValidationResult var1);

    @Nonnull
    public ArchiveVersionValidationResult validateArchiveVersion(@Nullable ApplicationUser var1, @Nonnull Version var2);

    @Nonnull
    public ArchiveVersionValidationResult validateUnarchiveVersion(@Nullable ApplicationUser var1, @Nonnull Version var2);

    public Version archiveVersion(ArchiveVersionValidationResult var1);

    public Version unarchiveVersion(ArchiveVersionValidationResult var1);

    public boolean isOverdue(Version var1);

    @Nonnull
    public MoveVersionValidationResult validateMoveToStartVersionSequence(@Nullable ApplicationUser var1, long var2);

    @Nonnull
    public MoveVersionValidationResult validateIncreaseVersionSequence(@Nullable ApplicationUser var1, long var2);

    @Nonnull
    public MoveVersionValidationResult validateDecreaseVersionSequence(@Nullable ApplicationUser var1, long var2);

    @Nonnull
    public MoveVersionValidationResult validateMoveToEndVersionSequence(@Nullable ApplicationUser var1, long var2);

    public MoveVersionValidationResult validateMoveVersionAfter(@Nullable ApplicationUser var1, long var2, @Nonnull Long var4);

    public void moveToStartVersionSequence(MoveVersionValidationResult var1);

    public void increaseVersionSequence(MoveVersionValidationResult var1);

    public void decreaseVersionSequence(MoveVersionValidationResult var1);

    public void moveToEndVersionSequence(MoveVersionValidationResult var1);

    public void moveVersionAfter(MoveVersionValidationResult var1);

    public long getFixIssuesCount(Version var1);

    public long getAffectsIssuesCount(Version var1);

    @Nonnull
    public Collection<CustomFieldWithVersionUsage> getCustomFieldsUsing(@Nonnull Version var1);

    public long getCustomFieldIssuesCount(@Nonnull Version var1);

    public long getUnresolvedIssuesCount(@Nullable ApplicationUser var1, @Nonnull Version var2);

    public DeleteVersionWithReplacementsParameterBuilder createVersionDeletaAndReplaceParameters(@Nonnull Version var1);

    public ServiceResult deleteVersionAndSwap(@Nonnull JiraServiceContext var1, @Nonnull DeleteVersionWithCustomFieldParameters var2);

    public VersionBuilder newVersionBuilder();

    public VersionBuilder newVersionBuilder(Version var1);

    @Nonnull
    public VersionBuilderValidationResult validateCreate(@Nullable ApplicationUser var1, @Nonnull VersionBuilder var2);

    @Nonnull
    public ServiceOutcome<Version> create(@Nullable ApplicationUser var1, @Nonnull VersionBuilderValidationResult var2);

    @Nonnull
    public VersionBuilderValidationResult validateUpdate(@Nullable ApplicationUser var1, @Nonnull VersionBuilder var2);

    public ServiceOutcome<Version> update(ApplicationUser var1, VersionBuilderValidationResult var2);

    public static class VersionBuilderValidationResult
    extends ReasonsServiceResult<CreateVersionValidationResult.Reason, VersionBuilder> {
        VersionBuilderValidationResult(ErrorCollection errorCollection, Set<CreateVersionValidationResult.Reason> reasons) {
            super(errorCollection, reasons);
        }

        VersionBuilderValidationResult(ErrorCollection errorCollection, Set<CreateVersionValidationResult.Reason> reasons, VersionBuilder versionBuilder) {
            super(errorCollection, reasons, versionBuilder);
        }
    }

    public static class ReasonsServiceResult<R, T>
    extends ServiceResultImpl {
        private final Set<R> specificReasons;
        private final T result;

        public ReasonsServiceResult(ErrorCollection errorCollection, Set<R> specificReasons) {
            super(errorCollection);
            this.specificReasons = Collections.unmodifiableSet(specificReasons);
            this.result = null;
        }

        public ReasonsServiceResult(ErrorCollection errorCollection, Set<R> specificReasons, T result) {
            super(errorCollection);
            this.specificReasons = Collections.unmodifiableSet(specificReasons);
            this.result = result;
        }

        public Set<R> getSpecificReasons() {
            return this.specificReasons;
        }

        public T getResult() {
            return this.result;
        }
    }

    @PublicApi
    public static interface VersionAction {
        public boolean isSwap();

        public Long getSwapVersionId();
    }

    @PublicApi
    public static class MoveVersionValidationResult
    extends AbstractVersionResult {
        private Long scheduleAfterVersion;
        private final Set<Reason> reasons;

        public MoveVersionValidationResult(ErrorCollection errorCollection, Set<Reason> reasons) {
            super(errorCollection);
            this.reasons = Collections.unmodifiableSet(reasons);
        }

        public MoveVersionValidationResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection, version);
            this.reasons = Collections.emptySet();
        }

        public MoveVersionValidationResult(ErrorCollection errorCollection, Version version, Long scheduleAfterVersion) {
            super(errorCollection, version);
            this.reasons = Collections.emptySet();
            this.scheduleAfterVersion = scheduleAfterVersion;
        }

        public Set<Reason> getReasons() {
            return this.reasons;
        }

        public Long getScheduleAfterVersion() {
            return this.scheduleAfterVersion;
        }

        public static enum Reason {
            FORBIDDEN,
            NOT_FOUND,
            SCHEDULE_AFTER_VERSION_NOT_FOUND;

        }
    }

    @PublicApi
    public static class ArchiveVersionValidationResult
    extends AbstractVersionResult {
        public ArchiveVersionValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public ArchiveVersionValidationResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection, version);
        }
    }

    @PublicApi
    public static class ReleaseVersionValidationResult
    extends AbstractVersionResult {
        private final Date releaseDate;

        public ReleaseVersionValidationResult(ErrorCollection errorCollection) {
            this(errorCollection, null, null);
        }

        public ReleaseVersionValidationResult(ErrorCollection errorCollection, Version version, Date releaseDate) {
            super(errorCollection, version);
            this.releaseDate = releaseDate;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }
    }

    @PublicApi
    public static class VersionsResult
    extends ServiceResultImpl {
        private final Collection<Version> versions;

        public VersionsResult(ErrorCollection errorCollection) {
            this(errorCollection, Collections.emptyList());
        }

        public VersionsResult(ErrorCollection errorCollection, Collection<Version> versions) {
            super(errorCollection);
            this.versions = versions;
        }

        public Collection<Version> getVersions() {
            return this.versions;
        }
    }

    @PublicApi
    public static class VersionResult
    extends AbstractVersionResult {
        public VersionResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public VersionResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection, version);
        }
    }

    @PublicApi
    public static abstract class AbstractVersionResult
    extends ServiceResultImpl {
        private final Version version;

        public AbstractVersionResult(ErrorCollection errorCollection) {
            this(errorCollection, (Version)null);
        }

        public AbstractVersionResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection);
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }
    }

    @PublicApi
    public static class CreateVersionValidationResult
    extends ServiceResultImpl {
        private final Project project;
        private final String versionName;
        private final Date startDate;
        private final Date releaseDate;
        private final String description;
        private final Long scheduleAfterVersion;
        private final Set<Reason> reasons;

        public CreateVersionValidationResult(ErrorCollection errorCollection, Set<Reason> reasons) {
            super(errorCollection);
            this.reasons = Collections.unmodifiableSet(reasons);
            this.project = null;
            this.versionName = null;
            this.startDate = null;
            this.releaseDate = null;
            this.description = null;
            this.scheduleAfterVersion = null;
        }

        public CreateVersionValidationResult(ErrorCollection errorCollection, Project project, String versionName, Date releaseDate, String description, Long scheduleAfterVersion) {
            super(errorCollection);
            this.reasons = Collections.emptySet();
            this.project = project;
            this.versionName = versionName;
            this.startDate = null;
            this.releaseDate = releaseDate;
            this.description = description;
            this.scheduleAfterVersion = scheduleAfterVersion;
        }

        public CreateVersionValidationResult(ErrorCollection errorCollection, Project project, String versionName, Date startDate, Date releaseDate, String description, Long scheduleAfterVersion) {
            super(errorCollection);
            this.reasons = Collections.emptySet();
            this.project = project;
            this.versionName = versionName;
            this.startDate = startDate;
            this.releaseDate = releaseDate;
            this.description = description;
            this.scheduleAfterVersion = scheduleAfterVersion;
        }

        public Project getProject() {
            return this.project;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }

        public String getDescription() {
            return this.description;
        }

        public Long getScheduleAfterVersion() {
            return this.scheduleAfterVersion;
        }

        public Set<Reason> getReasons() {
            return this.reasons;
        }

        public static enum Reason {
            FORBIDDEN,
            BAD_PROJECT,
            BAD_NAME,
            DUPLICATE_NAME,
            BAD_START_DATE,
            BAD_RELEASE_DATE,
            BAD_START_RELEASE_DATE_ORDER,
            VERSION_NAME_TOO_LONG;

        }
    }

    @PublicApi
    public static interface ValidationResult {
        public boolean isValid();

        public Version getVersionToDelete();

        public Version getFixSwapVersion();

        public Version getAffectsSwapVersion();

        @Deprecated
        public Option<Version> getVersionToMergeTo();

        public Set<Reason> getReasons();

        public ErrorCollection getErrorCollection();

        public Action getAction();

        public static enum Action {
            DELETE,
            MERGE,
            DELETE_AND_REPLACE;

        }

        public static enum Reason {
            FORBIDDEN,
            NOT_FOUND,
            SWAP_TO_VERSION_INVALID;

        }
    }

    public static enum VersionExtractableField implements OrderByRequests.ExtractableField<Version>
    {
        sequence{

            @Override
            public Comparable getValue(Version entity) {
                return entity.getSequence();
            }
        }
        ,
        name{

            @Override
            public Comparable getValue(Version entity) {
                return entity.getName();
            }
        }
        ,
        startDate{

            @Override
            public Comparable getValue(Version entity) {
                return entity.getStartDate();
            }
        }
        ,
        releaseDate{

            @Override
            public Comparable getValue(Version entity) {
                return entity.getReleaseDate();
            }
        };

    }
}

