/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jira.avatar.RemoteAvatar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.RemoteUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@ExperimentalApi
@Immutable
public final class RemoteProject {
    private final long id;
    private final String key;
    private final String name;
    private final String description;
    private final RemoteUser leadUser;
    private final String url;
    private final ApplicationLink applicationLink;
    private final RemoteAvatar avatar;

    public RemoteProject(long id, String key, String name, String description, RemoteUser leadUser, String url, ApplicationLink applicationLink, RemoteAvatar avatar) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.description = description;
        this.leadUser = leadUser;
        this.url = url;
        this.applicationLink = applicationLink;
        this.avatar = avatar;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public RemoteUser getLeadUser() {
        return this.leadUser;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public ApplicationLink getApplicationLink() {
        return this.applicationLink;
    }

    @Nonnull
    public RemoteAvatar getAvatar() {
        return this.avatar;
    }

    @Nonnull
    public String getBrowseProjectUrl() {
        return this.getServerBaseUrl() + "/browse/" + this.key;
    }

    @Nonnull
    public String getServerBaseUrl() {
        if (this.applicationLink == null) {
            return ComponentAccessor.getComponent(JiraBaseUrls.class).baseUrl();
        }
        return this.applicationLink.getDisplayUrl().toString();
    }

    @Nonnull
    public static RemoteProject from(Project project) {
        return new RemoteProject(project.getId(), project.getKey(), project.getName(), project.getDescription(), RemoteUser.from(project.getProjectLead()), project.getUrl(), null, RemoteAvatar.from(project));
    }

    @Nonnull
    public static RemoteProject from(ApplicationLink applicationLink, JSONObject jsonObject) throws JSONException {
        Builder builder = new Builder();
        builder.applicationLink(applicationLink);
        builder.id(jsonObject.getLong("id"));
        builder.key(jsonObject.getString("key"));
        builder.name(jsonObject.getString("name"));
        if (jsonObject.has("description")) {
            builder.description(jsonObject.getString("description"));
        }
        if (jsonObject.has("url")) {
            builder.url(jsonObject.getString("url"));
        }
        if (jsonObject.has("lead")) {
            builder.leadUser(RemoteUser.from(jsonObject.getJSONObject("lead")));
        }
        if (jsonObject.has("avatarUrls")) {
            builder.avatar(RemoteAvatar.from(jsonObject.getJSONObject("avatarUrls")));
        }
        return builder.build();
    }

    public static final class Builder {
        private long id;
        private String key;
        private String name;
        private String description;
        private RemoteUser leadUser;
        private String url;
        private ApplicationLink applicationLink;
        private RemoteAvatar avatar;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder applicationLink(ApplicationLink applicationLink) {
            this.applicationLink = applicationLink;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder leadUser(RemoteUser leadUser) {
            this.leadUser = leadUser;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder avatar(RemoteAvatar avatar) {
            this.avatar = avatar;
            return this;
        }

        public RemoteProject build() {
            return new RemoteProject(this.id, this.key, this.name, this.description, this.leadUser, this.url, this.applicationLink, this.avatar);
        }
    }
}

