/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyConditionHelper;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.plugin.webfragment.JiraWebContext;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

@PublicApi
public class EntityPropertyEqualToCondition
extends AbstractWebCondition {
    private static final Logger log = Logger.getLogger((String)EntityPropertyEqualToCondition.class.getName());
    private static final JsonParser jsonParser = new JsonParser();
    private final PluginAccessor pluginAccessor;
    private ConditionParameters conditionParameters;

    public EntityPropertyEqualToCondition(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
        super.init(params);
        String entity = this.getNonNullValueFromParameter(params, "entity");
        String propertyKey = this.getNonNullValueFromParameter(params, "propertyKey");
        String expectedValue = this.getNonNullValueFromParameter(params, "value");
        this.conditionParameters = new ConditionParameters(entity, propertyKey, expectedValue);
    }

    private String getNonNullValueFromParameter(Map<String, String> params, String parameter) {
        String value = params.get(parameter);
        if (value == null) {
            throw new PluginParseException(String.format("No '%s' parameter specified for condition: %s", parameter, this.getClass().getName()));
        }
        return value;
    }

    @Override
    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        Map<String, EntityPropertyConditionHelper> entityConditions = this.getEntityConditions();
        if (entityConditions.containsKey(this.conditionParameters.getEntity())) {
            EntityPropertyConditionHelper condition = entityConditions.get(this.conditionParameters.getEntity());
            Optional<Long> entityId = condition.getEntityId(JiraWebContext.from(jiraHelper.getContextParams()));
            if (!entityId.isPresent()) {
                return false;
            }
            EntityPropertyService.PropertyResult propertyResult = condition.getProperty(user, entityId.get(), this.conditionParameters.getPropertyKey());
            if (!propertyResult.isValid()) {
                return false;
            }
            Option<EntityProperty> entityProperty = propertyResult.getEntityProperty();
            return (Boolean)entityProperty.fold(Suppliers.alwaysFalse(), ep -> {
                JsonElement jsonElement = jsonParser.parse(ep.getValue());
                return jsonElement.isJsonPrimitive() && jsonElement.getAsString().equals(this.conditionParameters.getExpectedValue());
            });
        }
        log.warn((Object)("Entity property condition is registered for invalid entity. Supported entities are " + entityConditions.keySet()));
        return false;
    }

    private Map<String, EntityPropertyConditionHelper> getEntityConditions() {
        return this.pluginAccessor.getEnabledModulesByClass(EntityPropertyConditionHelper.class).stream().collect(Collectors.toMap(EntityPropertyConditionHelper::getEntityName, Function.identity()));
    }

    private static final class ConditionParameters {
        private final String entity;
        private final String propertyKey;
        private final String expectedValue;

        private ConditionParameters(String entity, String propertyKey, String expectedValue) {
            this.entity = entity;
            this.propertyKey = propertyKey;
            this.expectedValue = expectedValue;
        }

        public String getEntity() {
            return this.entity;
        }

        public String getExpectedValue() {
            return this.expectedValue;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }
    }
}

