/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.TransitionOptions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonNode;

@PublicApi
public interface IssueService {
    public IssueResult getIssue(@Nullable ApplicationUser var1, Long var2);

    public IssueResult getIssue(@Nullable ApplicationUser var1, String var2);

    public CreateValidationResult validateSubTaskCreate(ApplicationUser var1, Long var2, IssueInputParameters var3);

    public CreateValidationResult validateCreate(ApplicationUser var1, IssueInputParameters var2);

    public IssueResult create(ApplicationUser var1, CreateValidationResult var2);

    public IssueResult create(ApplicationUser var1, CreateValidationResult var2, String var3);

    public IssueResult update(ApplicationUser var1, UpdateValidationResult var2);

    public UpdateValidationResult validateUpdate(ApplicationUser var1, Long var2, IssueInputParameters var3);

    public IssueResult update(ApplicationUser var1, UpdateValidationResult var2, EventDispatchOption var3, boolean var4);

    public DeleteValidationResult validateDelete(ApplicationUser var1, Long var2);

    public ErrorCollection delete(ApplicationUser var1, DeleteValidationResult var2);

    public ErrorCollection delete(ApplicationUser var1, DeleteValidationResult var2, EventDispatchOption var3, boolean var4);

    public boolean isEditable(Issue var1, ApplicationUser var2);

    public TransitionValidationResult validateTransition(ApplicationUser var1, Long var2, int var3, IssueInputParameters var4);

    public TransitionValidationResult validateTransition(ApplicationUser var1, Long var2, int var3, IssueInputParameters var4, TransitionOptions var5);

    public IssueResult transition(ApplicationUser var1, TransitionValidationResult var2);

    public AssignValidationResult validateAssign(ApplicationUser var1, Long var2, String var3);

    public IssueResult assign(ApplicationUser var1, AssignValidationResult var2);

    public IssueInputParameters newIssueInputParameters();

    public IssueInputParameters newIssueInputParameters(Map<String, String[]> var1);

    @PublicApi
    public static abstract class IssueValidationResult
    extends ServiceResultImpl {
        private final MutableIssue issue;

        @Internal
        public IssueValidationResult(MutableIssue issue, ErrorCollection errors) {
            super(errors);
            this.issue = issue;
        }

        public MutableIssue getIssue() {
            return this.issue;
        }
    }

    public static class TransitionValidationResult
    extends ServiceResultImpl {
        private final MutableIssue issue;
        private final Map additionInputs;
        private final Map<String, Object> fieldValuesHolder;
        private final int actionId;

        public TransitionValidationResult(MutableIssue issue, ErrorCollection errors, Map<String, Object> fieldValuesHolder, Map additionInputs, int actionId) {
            super(errors);
            this.issue = issue;
            this.fieldValuesHolder = fieldValuesHolder;
            this.additionInputs = additionInputs;
            this.actionId = actionId;
        }

        public MutableIssue getIssue() {
            return this.issue;
        }

        public Map getAdditionInputs() {
            return this.additionInputs;
        }

        public int getActionId() {
            return this.actionId;
        }

        public Map<String, Object> getFieldValuesHolder() {
            return this.fieldValuesHolder;
        }
    }

    @PublicApi
    public static class IssueResult
    extends IssueValidationResult {
        @Internal
        public IssueResult(MutableIssue issue) {
            super(issue, new SimpleErrorCollection());
        }

        @Internal
        public IssueResult(MutableIssue issue, ErrorCollection errors) {
            super(issue, errors);
        }
    }

    public static class DeleteValidationResult
    extends IssueValidationResult {
        @Internal
        public DeleteValidationResult(MutableIssue issue, ErrorCollection errors) {
            super(issue, errors);
        }
    }

    public static class AssignValidationResult
    extends IssueValidationResult {
        private String assigneeId;

        @Internal
        public AssignValidationResult(MutableIssue issue, ErrorCollection errors, String assigneeId) {
            super(issue, errors);
            this.assigneeId = assigneeId;
        }

        public String getAssigneeId() {
            return this.assigneeId;
        }
    }

    public static class UpdateValidationResult
    extends IssueValidationResult {
        @Nullable
        private final HistoryMetadata historyMetadata;
        private final Map<String, Object> fieldValuesHolder;
        private final Map<String, JsonNode> properties;

        @Internal
        public UpdateValidationResult(MutableIssue issue, ErrorCollection errors, Map<String, Object> fieldValuesHolder) {
            this(issue, errors, fieldValuesHolder, null, Collections.emptyMap());
        }

        @Internal
        UpdateValidationResult(MutableIssue issue, ErrorCollection errors, Map<String, Object> fieldValuesHolder, @Nullable HistoryMetadata historyMetadata, Map<String, JsonNode> properties) {
            super(issue, errors);
            this.fieldValuesHolder = fieldValuesHolder;
            this.historyMetadata = historyMetadata;
            this.properties = ImmutableMap.copyOf(properties);
        }

        public Map<String, Object> getFieldValuesHolder() {
            return this.fieldValuesHolder;
        }

        @Nullable
        public HistoryMetadata getHistoryMetadata() {
            return this.historyMetadata;
        }

        public Map<String, JsonNode> getProperties() {
            return this.properties;
        }
    }

    public static class CreateValidationResult
    extends IssueValidationResult {
        private final Map<String, Object> fieldValuesHolder;
        private final Map<String, JsonNode> properties;

        @Internal
        public CreateValidationResult(MutableIssue issue, ErrorCollection errors, Map<String, Object> fieldValuesHolder, Map<String, JsonNode> properties) {
            super(issue, errors);
            this.fieldValuesHolder = fieldValuesHolder;
            this.properties = ImmutableMap.copyOf(properties);
        }

        public Map<String, Object> getFieldValuesHolder() {
            return this.fieldValuesHolder;
        }

        public Map<String, JsonNode> getProperties() {
            return this.properties;
        }
    }
}

