/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.request;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.sharing.SharedEntity;
import com.google.common.collect.Maps;
import java.util.Map;

@PublicApi
public enum SharedEntityType {
    SEARCH_REQUEST(SearchRequest.ENTITY_TYPE),
    PORTAL_PAGE(PortalPage.ENTITY_TYPE),
    NONE(null);

    private SharedEntity.TypeDescriptor typeDescriptor;
    private static Map<SharedEntity.TypeDescriptor, SharedEntityType> typeDescriptorSharedEntityTypeMap;

    private SharedEntityType(SharedEntity.TypeDescriptor typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
    }

    public SharedEntity.TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public static SharedEntityType fromTypeDescriptor(SharedEntity.TypeDescriptor typeDescriptor) {
        if (typeDescriptorSharedEntityTypeMap == null) {
            SharedEntityType.initialiseTypeDescriptorMap();
        }
        if (typeDescriptor == null) {
            return NONE;
        }
        return typeDescriptorSharedEntityTypeMap.get(typeDescriptor);
    }

    private static void initialiseTypeDescriptorMap() {
        typeDescriptorSharedEntityTypeMap = Maps.newHashMap();
        for (SharedEntityType type : SharedEntityType.values()) {
            if (type.getTypeDescriptor() == null) continue;
            typeDescriptorSharedEntityTypeMap.put(type.getTypeDescriptor(), type);
        }
    }
}

