/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public abstract class AbstractOperatorQueryFactory<T> {
    private final IndexInfoResolver indexInfoResolver;

    protected AbstractOperatorQueryFactory(IndexInfoResolver indexInfoResolver) {
        this.indexInfoResolver = indexInfoResolver;
    }

    protected TermQuery getTermQuery(String fieldName, String indexValue) {
        return new TermQuery(new Term(fieldName, indexValue));
    }

    protected QueryFactoryResult checkQueryForEmpty(BooleanQuery query) {
        if (query.clauses().isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        return new QueryFactoryResult((Query)query);
    }

    List<String> getIndexValues(List<QueryLiteral> rawValues) {
        if (rawValues == null || rawValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList indexValues = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            List<String> vals;
            if (rawValue == null) continue;
            if (rawValue.getStringValue() != null) {
                vals = this.indexInfoResolver.getIndexedValues(rawValue.getStringValue());
            } else if (rawValue.getLongValue() != null) {
                vals = this.indexInfoResolver.getIndexedValues(rawValue.getLongValue());
            } else {
                indexValues.add(null);
                continue;
            }
            if (vals == null || vals.isEmpty()) continue;
            indexValues.addAll(vals);
        }
        return indexValues;
    }
}

