/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.projectroles;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiMap;

@PublicApi
public interface ProjectRoleService {
    public static final String PROJECTROLE_ISSUE_SECURITY_TYPE = "projectrole";
    public static final String PROJECTROLE_PERMISSION_TYPE = "projectrole";
    public static final String PROJECTROLE_NOTIFICATION_TYPE = "Project_Role";

    public Collection<ProjectRole> getProjectRoles(ErrorCollection var1);

    public Collection<ProjectRole> getProjectRoles(ApplicationUser var1, ErrorCollection var2);

    public ProjectRole getProjectRole(Long var1, ErrorCollection var2);

    public ProjectRole getProjectRole(ApplicationUser var1, Long var2, ErrorCollection var3);

    public ProjectRole getProjectRoleByName(String var1, ErrorCollection var2);

    public ProjectRole getProjectRoleByName(ApplicationUser var1, String var2, ErrorCollection var3);

    public ProjectRole createProjectRole(ProjectRole var1, ErrorCollection var2);

    public ProjectRole createProjectRole(ApplicationUser var1, ProjectRole var2, ErrorCollection var3);

    public boolean isProjectRoleNameUnique(String var1, ErrorCollection var2);

    public boolean isProjectRoleNameUnique(ApplicationUser var1, String var2, ErrorCollection var3);

    public void deleteProjectRole(ProjectRole var1, ErrorCollection var2);

    public void deleteProjectRole(ApplicationUser var1, ProjectRole var2, ErrorCollection var3);

    public void addActorsToProjectRole(Collection<String> var1, ProjectRole var2, Project var3, String var4, ErrorCollection var5);

    public void addActorsToProjectRole(ApplicationUser var1, Collection<String> var2, ProjectRole var3, Project var4, String var5, ErrorCollection var6);

    public void removeActorsFromProjectRole(Collection<String> var1, ProjectRole var2, Project var3, String var4, ErrorCollection var5);

    public void removeActorsFromProjectRole(ApplicationUser var1, Collection<String> var2, ProjectRole var3, Project var4, String var5, ErrorCollection var6);

    public void setActorsForProjectRole(Map<String, Set<String>> var1, ProjectRole var2, Project var3, ErrorCollection var4);

    public void setActorsForProjectRole(ApplicationUser var1, Map<String, Set<String>> var2, ProjectRole var3, Project var4, ErrorCollection var5);

    public void updateProjectRole(ProjectRole var1, ErrorCollection var2);

    public void updateProjectRole(ApplicationUser var1, ProjectRole var2, ErrorCollection var3);

    public ProjectRoleActors getProjectRoleActors(ProjectRole var1, Project var2, ErrorCollection var3);

    public ProjectRoleActors getProjectRoleActors(ApplicationUser var1, ProjectRole var2, Project var3, ErrorCollection var4);

    public DefaultRoleActors getDefaultRoleActors(ProjectRole var1, ErrorCollection var2);

    public DefaultRoleActors getDefaultRoleActors(ApplicationUser var1, ProjectRole var2, ErrorCollection var3);

    public void addDefaultActorsToProjectRole(Collection<String> var1, ProjectRole var2, String var3, ErrorCollection var4);

    public void addDefaultActorsToProjectRole(ApplicationUser var1, Collection<String> var2, ProjectRole var3, String var4, ErrorCollection var5);

    public void removeDefaultActorsFromProjectRole(Collection<String> var1, ProjectRole var2, String var3, ErrorCollection var4);

    public void removeDefaultActorsFromProjectRole(ApplicationUser var1, Collection<String> var2, ProjectRole var3, String var4, ErrorCollection var5);

    public void removeAllRoleActorsByNameAndType(String var1, String var2, ErrorCollection var3);

    public void removeAllRoleActorsByNameAndType(ApplicationUser var1, String var2, String var3, ErrorCollection var4);

    public ErrorCollection validateRemoveAllRoleActorsByNameAndType(String var1, String var2);

    public ErrorCollection validateRemoveAllRoleActorsByNameAndType(ApplicationUser var1, String var2, String var3);

    public void removeAllRoleActorsByNameAndType(String var1, String var2);

    public void removeAllRoleActorsByProject(Project var1, ErrorCollection var2);

    public void removeAllRoleActorsByProject(ApplicationUser var1, Project var2, ErrorCollection var3);

    public Collection getAssociatedNotificationSchemes(ProjectRole var1, ErrorCollection var2);

    public Collection getAssociatedNotificationSchemes(ApplicationUser var1, ProjectRole var2, ErrorCollection var3);

    public Collection getAssociatedPermissionSchemes(ProjectRole var1, ErrorCollection var2);

    public Collection getAssociatedPermissionSchemes(ApplicationUser var1, ProjectRole var2, ErrorCollection var3);

    public Collection getAssociatedIssueSecuritySchemes(ProjectRole var1, ErrorCollection var2);

    public Collection getAssociatedIssueSecuritySchemes(ApplicationUser var1, ProjectRole var2, ErrorCollection var3);

    public MultiMap getAssociatedWorkflows(ProjectRole var1, ErrorCollection var2);

    public MultiMap getAssociatedWorkflows(ApplicationUser var1, ProjectRole var2, ErrorCollection var3);

    public Collection<Project> getProjectsContainingRoleActorByNameAndType(String var1, String var2, ErrorCollection var3);

    public Collection<Project> getProjectsContainingRoleActorByNameAndType(ApplicationUser var1, String var2, String var3, ErrorCollection var4);

    public List<Long> roleActorOfTypeExistsForProjects(List<Long> var1, ProjectRole var2, String var3, String var4, ErrorCollection var5);

    public List<Long> roleActorOfTypeExistsForProjects(ApplicationUser var1, List<Long> var2, ProjectRole var3, String var4, String var5, ErrorCollection var6);

    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> var1, ProjectRole var2, String var3, String var4, ErrorCollection var5);

    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(ApplicationUser var1, List<Long> var2, ProjectRole var3, String var4, String var5, ErrorCollection var6);

    public boolean hasProjectRolePermission(Project var1);

    public boolean hasProjectRolePermission(ApplicationUser var1, Project var2);
}

