/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.clause;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClausePrecedence;
import com.atlassian.query.clause.ClauseVisitor;
import java.util.Collections;
import java.util.List;

public class NotClause
implements Clause {
    public static final String NOT = "NOT";
    private final Clause subClause;

    public NotClause(Clause subClause) {
        this.subClause = Assertions.notNull("subClause", subClause);
    }

    @Override
    public String getName() {
        return NOT;
    }

    @Override
    public List<Clause> getClauses() {
        return Collections.singletonList(this.subClause);
    }

    @Override
    public <R> R accept(ClauseVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public Clause getSubClause() {
        return this.subClause;
    }

    @Override
    public String toString() {
        ClausePrecedence currentPrecedence = ClausePrecedence.getPrecedence(this);
        ClausePrecedence subClausePrecedence = ClausePrecedence.getPrecedence(this.subClause);
        StringBuilder sb = new StringBuilder(NOT).append(" ");
        if (subClausePrecedence.getValue() < currentPrecedence.getValue()) {
            sb.append("( ");
        }
        sb.append(this.subClause.toString());
        if (subClausePrecedence.getValue() < currentPrecedence.getValue()) {
            sb.append(" )");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotClause notClause = (NotClause)o;
        return this.subClause.equals(notClause.subClause);
    }

    public int hashCode() {
        return this.subClause.hashCode();
    }
}

