/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserDetails;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface UserUtil {
    public static final String META_PROPERTY_PREFIX = "jira.meta.";

    @Deprecated
    public int getTotalUserCount();

    @Deprecated
    public void clearActiveUserCount();

    @Deprecated
    @Nonnull
    public Collection<ApplicationUser> getUsers();

    @Deprecated
    @Nonnull
    public Collection<ApplicationUser> getAllApplicationUsers();

    public Group getGroup(@Nullable String var1);

    @Deprecated
    public Group getGroupObject(@Nullable String var1);

    public ApplicationUser createUserWithNotification(String var1, String var2, String var3, String var4, int var5) throws PermissionException, CreateException;

    public ApplicationUser createUserWithNotification(String var1, String var2, String var3, String var4, Long var5, int var6) throws PermissionException, CreateException;

    public ApplicationUser createUserNoNotification(String var1, String var2, String var3, String var4) throws PermissionException, CreateException;

    public ApplicationUser createUserNoNotification(String var1, String var2, String var3, String var4, Long var5) throws PermissionException, CreateException;

    @Nonnull
    @ExperimentalApi
    @Deprecated
    @Internal
    public ApplicationUser createUser(@Nonnull UserDetails var1, boolean var2, int var3, @Nullable Set<ApplicationKey> var4) throws PermissionException, CreateException;

    public void removeUser(ApplicationUser var1, ApplicationUser var2);

    public void addUserToGroup(Group var1, ApplicationUser var2) throws PermissionException, AddException;

    public void addUserToGroups(Collection<Group> var1, ApplicationUser var2) throws PermissionException, AddException;

    public void removeUserFromGroup(Group var1, ApplicationUser var2) throws PermissionException, RemoveException;

    public void removeUserFromGroups(Collection<Group> var1, ApplicationUser var2) throws PermissionException, RemoveException;

    public PasswordResetToken generatePasswordResetToken(ApplicationUser var1);

    public PasswordResetTokenValidation validatePasswordResetToken(ApplicationUser var1, String var2);

    public void changePassword(ApplicationUser var1, String var2) throws UserNotFoundException, InvalidCredentialException, OperationNotPermittedException, PermissionException;

    @Deprecated
    public int getActiveUserCount();

    @Deprecated
    public boolean canActivateNumberOfUsers(int var1);

    public ApplicationUser getUser(String var1);

    public ApplicationUser getUserByKey(String var1);

    public ApplicationUser getUserByName(String var1);

    public ApplicationUser getUserObject(String var1);

    public boolean userExists(String var1);

    public Collection<ApplicationUser> getAdministrators();

    public Collection<ApplicationUser> getJiraAdministrators();

    public Collection<ApplicationUser> getSystemAdministrators();

    public Collection<ApplicationUser> getJiraSystemAdministrators();

    @Deprecated
    public void addToJiraUsePermission(ApplicationUser var1) throws PermissionException;

    public Collection<ProjectComponent> getComponentsUserLeads(ApplicationUser var1);

    public Collection<Project> getProjectsLeadBy(ApplicationUser var1);

    public boolean isNonSysAdminAttemptingToDeleteSysAdmin(ApplicationUser var1, ApplicationUser var2);

    public long getNumberOfReportedIssuesIgnoreSecurity(ApplicationUser var1, ApplicationUser var2) throws SearchException;

    public long getNumberOfAssignedIssuesIgnoreSecurity(ApplicationUser var1, ApplicationUser var2) throws SearchException;

    public String getDisplayableNameSafely(ApplicationUser var1);

    public SortedSet<Group> getGroupsForUser(String var1);

    public SortedSet<String> getGroupNamesForUser(String var1);

    public SortedSet<ApplicationUser> getAllUsersInGroupNames(Collection<String> var1);

    public Set<ApplicationUser> getAllUsersInGroupNamesUnsorted(Collection<String> var1);

    public SortedSet<ApplicationUser> getUsersInGroupNames(Collection<String> var1);

    public SortedSet<ApplicationUser> getAllUsersInGroups(Collection<Group> var1);

    public SortedSet<ApplicationUser> getUsersInGroups(Collection<Group> var1);

    public static interface PasswordResetTokenValidation {
        public Status getStatus();

        public static enum Status {
            EXPIRED,
            UNEQUAL,
            OK;

        }
    }

    public static interface PasswordResetToken {
        public ApplicationUser getUser();

        public String getToken();

        public int getExpiryHours();

        public long getExpiryTime();
    }
}

