/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ContextProjectMap;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContextSetUtil {
    private static final ContextSetUtil INSTANCE = new ContextSetUtil();
    private static final ProjectIssueTypeContext GLOBAL_CONTEXT = ProjectIssueTypeContextImpl.createGlobalContext();

    public static ContextSetUtil getInstance() {
        return INSTANCE;
    }

    public ClauseContext intersect(Set<? extends ClauseContext> childClauseContexts) {
        Assertions.containsNoNulls("childClauseContexts", childClauseContexts);
        if (childClauseContexts.isEmpty()) {
            return new ClauseContextImpl();
        }
        Iterator<? extends ClauseContext> iter = childClauseContexts.iterator();
        ClauseContext intersection = iter.next();
        if (childClauseContexts.size() == 1) {
            return new ClauseContextImpl(intersection.getContexts());
        }
        while (iter.hasNext()) {
            ClauseContext toIntersect = iter.next();
            intersection = this.intersect(intersection, toIntersect);
        }
        return intersection;
    }

    public ClauseContext union(Set<? extends ClauseContext> childClauseContexts) {
        Assertions.containsNoNulls("childClauseContexts", childClauseContexts);
        if (childClauseContexts.isEmpty()) {
            return new ClauseContextImpl();
        }
        Iterator<? extends ClauseContext> iter = childClauseContexts.iterator();
        ClauseContext union = iter.next();
        while (iter.hasNext()) {
            ClauseContext toUnion = iter.next();
            union = this.union(union, toUnion);
        }
        return union;
    }

    @Nonnull
    private ClauseContext intersect(@Nonnull ClauseContext context1, @Nonnull ClauseContext context2) {
        ClauseContext clauseContext = this.shortCircuitIfBothGlobal(context1, context2);
        if (clauseContext != null) {
            return clauseContext;
        }
        ContextProjectMap contextProjectMap1 = new ContextProjectMap(context1);
        ContextProjectMap contextProjectMap2 = new ContextProjectMap(context2);
        clauseContext = contextProjectMap1.intersect(contextProjectMap2);
        return clauseContext;
    }

    @Nonnull
    private ClauseContext union(@Nonnull ClauseContext context1, @Nonnull ClauseContext context2) {
        ContextProjectMap contextProjectMap1 = new ContextProjectMap(context1);
        ContextProjectMap contextProjectMap2 = new ContextProjectMap(context2);
        return contextProjectMap1.union(contextProjectMap2);
    }

    @Nonnull
    private Map<ProjectContext, Set<IssueTypeContext>> handleProjectGlobals(@Nullable Set<IssueTypeContext> issueTypeContexts, @Nonnull Set<ProjectContext> projectContexts) {
        HashMap resultsMap = Maps.newHashMap();
        if (issueTypeContexts != null) {
            for (ProjectContext projectContext : projectContexts) {
                resultsMap.put(projectContext, issueTypeContexts);
            }
        }
        return resultsMap;
    }

    @Nullable
    private ClauseContext shortCircuitIfBothGlobal(@Nonnull ClauseContext context1, @Nonnull ClauseContext context2) {
        if (context1.getContexts().contains(GLOBAL_CONTEXT) && context2.getContexts().contains(GLOBAL_CONTEXT)) {
            return new ClauseContextImpl((Set<ProjectIssueTypeContext>)Sets.union(context1.getContexts(), context2.getContexts()));
        }
        return null;
    }
}

