/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.statistics.CascadingOption;
import java.util.Comparator;
import javax.annotation.Nullable;

@Internal
public class CascadingOptionComparator
implements Comparator<CascadingOption> {
    private final Comparator<Option> optionComparator = CascadingOptionComparator.getComparator();

    public static Comparator<Option> getComparator() {
        return new Comparator<Option>(){

            @Override
            public int compare(@Nullable Option option1, @Nullable Option option2) {
                if (option1 == null && option2 == null) {
                    return 0;
                }
                if (option1 == null) {
                    return -1;
                }
                if (option2 == null) {
                    return 1;
                }
                return option1.getSequence().compareTo(option2.getSequence());
            }
        };
    }

    @Override
    public int compare(CascadingOption o1, CascadingOption o2) {
        Option parent2;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Option parent1 = o1.getParent();
        int parentResult = this.optionComparator.compare(parent1, parent2 = o2.getParent());
        if (parentResult != 0) {
            return parentResult;
        }
        Option child1 = o1.getChild();
        Option child2 = o2.getChild();
        return this.optionComparator.compare(child1, child2);
    }
}

