/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.option.SimpleOption;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

@ExperimentalApi
public interface OptionsService {
    @Nonnull
    public ServiceOutcome<SetValidateResult> validateSetOptions(@Nonnull SetOptionParams var1);

    @Nonnull
    public ServiceOutcome<Options> setOptions(@Nonnull SetValidateResult var1);

    @ExperimentalApi
    public static interface SetValidateResult {
    }

    @ExperimentalApi
    public static class SetOptionParams {
        private ApplicationUser user;
        private CustomField customField;
        private IssueContext issueContext;
        private FieldConfig fieldConfig;
        private Iterable<? extends SimpleOption<?>> options;

        public FieldConfig fieldConfig() {
            return this.fieldConfig;
        }

        public SetOptionParams fieldConfig(FieldConfig config) {
            this.fieldConfig = config;
            return this;
        }

        public CustomField customField() {
            return this.customField;
        }

        public SetOptionParams customField(CustomField customField, IssueContext context) {
            this.customField = customField;
            this.issueContext = context;
            return this;
        }

        public IssueContext issueContext() {
            return this.issueContext;
        }

        public Iterable<? extends SimpleOption<?>> options() {
            return this.options;
        }

        public SetOptionParams option(Iterable<? extends SimpleOption<?>> options) {
            this.options = ImmutableList.copyOf(options);
            return this;
        }

        public SetOptionParams option(SimpleOption<?> ... options) {
            this.options = ImmutableList.copyOf((Object[])options);
            return this;
        }

        public ApplicationUser user() {
            return this.user;
        }

        public SetOptionParams user(ApplicationUser user) {
            this.user = user;
            return this;
        }

        public void validate() {
            if (this.customField() == null) {
                if (this.fieldConfig() == null) {
                    throw new IllegalArgumentException("CustomField or FieldConfig must be passed.");
                }
            } else if (this.issueContext() == null) {
                throw new IllegalArgumentException("IssueContext must be passed with CustomField.");
            }
            if (this.options() == null) {
                throw new IllegalArgumentException("Options must be passed.");
            }
        }
    }
}

