/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.IssueConstant;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Comparator;

@ExperimentalApi
public final class IssueConstants {
    private static Function<IssueConstant, String> GET_ID = new Function<IssueConstant, String>(){

        public String apply(IssueConstant input) {
            return input.getId();
        }
    };
    private static Function<IssueConstant, String> GET_I18N_NAME = new Function<IssueConstant, String>(){

        public String apply(IssueConstant input) {
            return input.getNameTranslation();
        }
    };

    private IssueConstants() {
    }

    public static Function<IssueConstant, String> getId() {
        return GET_ID;
    }

    public static Function<IssueConstant, String> getIdFunc() {
        return GET_ID;
    }

    public static Function<IssueConstant, String> getTranslatedNameFunc() {
        return GET_I18N_NAME;
    }

    public static Iterable<String> getIds(Iterable<? extends IssueConstant> constants) {
        return Iterables.transform(constants, IssueConstants.getId());
    }

    public static Function<IssueConstant, Long> getIdAsLong() {
        return new Function<IssueConstant, Long>(){

            public Long apply(IssueConstant input) {
                return Long.valueOf(input.getId());
            }
        };
    }

    public static Iterable<? extends String> toStringIds(Collection<? extends IssueConstant> issueConstants) {
        return Iterables.transform(issueConstants, (Function)new Function<IssueConstant, String>(){

            public String apply(IssueConstant input) {
                return input != null ? input.getId() : "-1";
            }
        });
    }

    public static Iterable<? extends String> toStringIdsWithoutNulls(Collection<? extends IssueConstant> issueConstants) {
        return Iterables.transform((Iterable)Iterables.filter(issueConstants, (Predicate)Predicates.notNull()), (Function)new Function<IssueConstant, String>(){

            public String apply(IssueConstant input) {
                return input.getId();
            }
        });
    }

    public static Comparator<IssueConstant> getSequenceComparator() {
        return new Comparator<IssueConstant>(){

            @Override
            public int compare(IssueConstant o1, IssueConstant o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o2 == null) {
                    return -1;
                }
                if (o1 == null) {
                    return 1;
                }
                Long s1 = o1.getSequence();
                Long s2 = o2.getSequence();
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s2 == null) {
                    return -1;
                }
                if (s1 == null) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
        };
    }
}

