/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.fugue.Option;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AttachmentError {
    private final String logMessage;
    private final String localizedMessage;
    private final String filename;
    private final ErrorCollection.Reason reason;
    private final Option<Exception> exception;

    public AttachmentError(String logMessage, String localizedMessage, String filename, Option<Exception> exception, ErrorCollection.Reason reason) {
        this.logMessage = logMessage;
        this.localizedMessage = localizedMessage;
        this.filename = filename;
        this.reason = reason;
        this.exception = exception;
    }

    public AttachmentError(String logMessage, String localizedMessage, String filename, ErrorCollection.Reason reason) {
        this(logMessage, localizedMessage, filename, (Option<Exception>)Option.none(), reason);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    public Option<Exception> getException() {
        return this.exception;
    }

    public ErrorCollection.Reason getReason() {
        return this.reason;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.logMessage, this.localizedMessage, this.filename, this.reason, this.exception});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentError other = (AttachmentError)obj;
        return Objects.equal((Object)this.logMessage, (Object)other.logMessage) && Objects.equal((Object)this.localizedMessage, (Object)other.localizedMessage) && Objects.equal((Object)this.filename, (Object)other.filename) && Objects.equal((Object)((Object)this.reason), (Object)((Object)other.reason)) && Objects.equal(this.exception, other.exception);
    }

    public String toString() {
        return "AttachmentError{logMessage='" + this.logMessage + '\'' + ", localizedMessage='" + this.localizedMessage + '\'' + ", filename='" + this.filename + '\'' + ", reason=" + (Object)((Object)this.reason) + ", exception=" + this.exception + '}';
    }
}

