/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.project;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Option;
import com.atlassian.jira.event.project.AbstractVersionEvent;
import com.atlassian.jira.project.version.Version;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VersionDeleteEvent
extends AbstractVersionEvent {
    private final Option<Version> mergedTo;
    private final Option<Version> affectsVersionSwappedTo;
    private final Option<Version> fixVersionSwappedTo;

    @Deprecated
    @Internal
    public VersionDeleteEvent(@Nonnull Version version) {
        this(version, null, null, null);
    }

    private VersionDeleteEvent(@Nonnull Version version, @Nullable Version mergedTo, @Nullable Version affectsVersionSwappedTo, @Nullable Version fixSwapVersion) {
        super(version);
        this.mergedTo = Option.option((Object)mergedTo);
        this.affectsVersionSwappedTo = Option.option((Object)affectsVersionSwappedTo);
        this.fixVersionSwappedTo = Option.option((Object)fixSwapVersion);
    }

    public static VersionDeleteEvent deletedAndMerged(@Nonnull Version deletedVersion, @Nonnull Version mergedTo) {
        return new VersionDeleteEventBuilder(deletedVersion).setMergedTo(mergedTo).createEvent();
    }

    public static VersionDeleteEvent deleted(@Nonnull Version deletedVersion) {
        return new VersionDeleteEventBuilder(deletedVersion).createEvent();
    }

    public Option<Version> getMergedTo() {
        return this.mergedTo;
    }

    public Option<Version> getAffectsVersionSwappedTo() {
        return this.affectsVersionSwappedTo;
    }

    public Option<Version> getFixVersionSwappedTo() {
        return this.fixVersionSwappedTo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VersionDeleteEvent that = (VersionDeleteEvent)o;
        if (this.affectsVersionSwappedTo != null ? !this.affectsVersionSwappedTo.equals(that.affectsVersionSwappedTo) : that.affectsVersionSwappedTo != null) {
            return false;
        }
        if (this.fixVersionSwappedTo != null ? !this.fixVersionSwappedTo.equals(that.fixVersionSwappedTo) : that.fixVersionSwappedTo != null) {
            return false;
        }
        return !(this.mergedTo != null ? !this.mergedTo.equals(that.mergedTo) : that.mergedTo != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.mergedTo != null ? this.mergedTo.hashCode() : 0);
        result = 31 * result + (this.affectsVersionSwappedTo != null ? this.affectsVersionSwappedTo.hashCode() : 0);
        result = 31 * result + (this.fixVersionSwappedTo != null ? this.fixVersionSwappedTo.hashCode() : 0);
        return result;
    }

    public static class VersionDeleteEventBuilder {
        private final Version version;
        private Version mergedTo;
        private Version affectsVersionSwappedTo;
        private Version fixSwapVersion;

        public VersionDeleteEventBuilder(Version version) {
            this.version = (Version)Preconditions.checkNotNull((Object)version);
        }

        public VersionDeleteEventBuilder setMergedTo(Version mergedTo) {
            this.mergedTo = mergedTo;
            return this;
        }

        public VersionDeleteEventBuilder affectsVersionSwappedTo(Version affectsVersionSwappedTo) {
            this.affectsVersionSwappedTo = affectsVersionSwappedTo;
            return this;
        }

        public VersionDeleteEventBuilder fixVersionSwappedTo(Version fixSwapVersion) {
            this.fixSwapVersion = fixSwapVersion;
            return this;
        }

        public VersionDeleteEvent createEvent() {
            return new VersionDeleteEvent(this.version, this.mergedTo, this.affectsVersionSwappedTo, this.fixSwapVersion);
        }
    }
}

