/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.mail;

import com.atlassian.annotations.Internal;
import com.atlassian.configurable.ObjectConfigurable;
import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.service.services.mail.DeadLetterStore;
import com.atlassian.jira.service.services.mail.DelegatingMessageHandlerContext;
import com.atlassian.jira.service.services.mail.ErrorAccumulatingMessageHandlerExecutionMonitor;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.PortUtil;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.sun.mail.pop3.POP3Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

@Internal
public class MailFetcherService
extends AbstractMessageHandlingService
implements ObjectConfigurable {
    private static final Logger log = ComponentAccessor.getComponent(MailLoggingManager.class).getIncomingMailChildLogger("mailfetcherservice");
    private static final String OLD_MAIL_DISABLED_KEY = "atlassian.mail.popdisabled";
    private static final String MAIL_DISABLED_KEY = "atlassian.mail.fetchdisabled";
    public static final String KEY_MAIL_SERVER = "popserver";
    protected Long mailserverId = null;
    public static final String FORWARD_EMAIL = "forwardEmail";
    protected static final String DEFAULT_FOLDER = "INBOX";
    public static final String FOLDER_NAME_KEY = "foldername";
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private final ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
    private final String baseUrl = this.applicationProperties.getString("jira.baseurl");
    private final MailSettings.Fetch settings;
    private static final String ERROR_TEMPLATE = "errorinhandler.vm";
    private final ErrorEmailForwarder errorEmailForwarder;
    private final MessageProvider messageProvider;
    private final DeadLetterStore deadLetterStore;

    @VisibleForTesting
    MailFetcherService(MailSettings.Fetch settings, ErrorEmailForwarder errorEmailForwarder, MessageProvider messageProvider, DeadLetterStore deadLetterStore) {
        this.settings = settings;
        this.errorEmailForwarder = errorEmailForwarder;
        this.messageProvider = messageProvider;
        this.deadLetterStore = deadLetterStore;
    }

    public MailFetcherService() {
        this.errorEmailForwarder = new ErrorEmailForwarderImpl();
        this.messageProvider = new MessageProviderImpl();
        this.settings = ComponentAccessor.getComponent(MailSettings.class).fetch();
        this.deadLetterStore = this.getDeadLetterStore();
    }

    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(KEY_MAIL_SERVER)) {
            try {
                this.mailserverId = new Long(this.getProperty(KEY_MAIL_SERVER));
            }
            catch (Exception e) {
                log.error((Object)("Invalid mail server id: " + e), (Throwable)e);
            }
        }
    }

    protected int getPort(MailServer server) {
        int parsedPort = PortUtil.parsePort(server.getPort());
        if (parsedPort >= 0) {
            return parsedPort;
        }
        log.error((Object)("Invalid port number: " + server.getPort() + " for mail service: " + this.getName() + ". Using the default port for this service type."));
        return -1;
    }

    private Message[] getUnprocessedMessages(Folder folder) throws MessagingException {
        return folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DELETED), false));
    }

    @Override
    protected void runImpl(MessageHandlerContext context) {
        log.debug((Object)(this.getClass().getSimpleName() + " run() method has been called"));
        if (this.isMailDisabled()) {
            context.getMonitor().info("Mail is disabled.");
            return;
        }
        final MessageHandler messageHandler = this.getHandler();
        if (messageHandler == null) {
            log.error((Object)"Message Handler is not configured properly for this service. Exiting.");
            return;
        }
        MailServer mailserver = this.getMailServer(context.getMonitor());
        if (mailserver == null) {
            context.getMonitor().warning("no mail server returned from getMailServer(). Exiting run()");
            return;
        }
        this.deadLetterStore.deleteOldDeadLetters();
        this.messageProvider.getAndProcessMail(new MessageProvider.SingleMessageProcessor(){

            @Override
            public boolean process(Message message, MessageHandlerContext context) throws MessagingException, MailException {
                ErrorAccumulatingMessageHandlerExecutionMonitor accumulatingMonitor = new ErrorAccumulatingMessageHandlerExecutionMonitor(context.getMonitor());
                DelegatingMessageHandlerContext myMessageHandlerContext = new DelegatingMessageHandlerContext(context, accumulatingMonitor);
                log.debug((Object)"Calling handleMessage");
                boolean deleteThisMessage = messageHandler.handleMessage(message, myMessageHandlerContext);
                if ((accumulatingMonitor.hasErrors() && !deleteThisMessage || accumulatingMonitor.isMessagedMarkedForDeletion() || accumulatingMonitor.isMarkedToForward()) && MailFetcherService.this.forwardEmailParam() != null) {
                    String toAddress = MailFetcherService.this.forwardEmailParam();
                    log.debug((Object)("Forwarding error message to '" + toAddress + "'"));
                    deleteThisMessage = MailFetcherService.this.errorEmailForwarder.forwardEmail(message, myMessageHandlerContext, toAddress, accumulatingMonitor.getErrorsAsString(), accumulatingMonitor.getExceptionsAsString());
                }
                return deleteThisMessage || accumulatingMonitor.isMessagedMarkedForDeletion();
            }
        }, mailserver, context);
    }

    @VisibleForTesting
    Optional<Store> getStore(MailServer mailServer, String protocol, MessageHandlerExecutionMonitor monitor) {
        Session session;
        try {
            session = mailServer.getSession();
        }
        catch (Exception e) {
            monitor.error("Cannot create mail session: " + e.getMessage(), e);
            return Optional.absent();
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting store from the session using protocol [" + protocol + "]"));
            }
            return Optional.of((Object)session.getStore(protocol));
        }
        catch (NoSuchProviderException e) {
            monitor.error("Error getting provider for protocol " + protocol + ": " + (Object)((Object)e), e);
            return Optional.absent();
        }
    }

    @VisibleForTesting
    DeadLetterStore getDeadLetterStore() {
        return new DeadLetterStore(log);
    }

    private MailServer getMailServer(MessageHandlerExecutionMonitor monitor) {
        MailServer mailserver = null;
        if (this.mailserverId != null) {
            try {
                mailserver = this.getMailServerManager().getMailServer(new Long(this.getProperty(KEY_MAIL_SERVER)));
            }
            catch (Exception e) {
                monitor.error("Could not retrieve mail server: " + e, e);
            }
        } else {
            monitor.error(this.getClass().getName() + " cannot run without a configured Mail Server");
        }
        return mailserver;
    }

    @VisibleForTesting
    MailServerManager getMailServerManager() {
        return MailFactory.getServerManager();
    }

    @Deprecated
    boolean isMailDisabled() {
        return this.settings.isDisabled();
    }

    protected String getFolderName(MailServer server) {
        if (server.getMailProtocol().equals((Object)MailProtocol.SECURE_IMAP) || server.getMailProtocol().equals((Object)MailProtocol.IMAP)) {
            try {
                return StringUtils.defaultString((String)this.getProperty(FOLDER_NAME_KEY), (String)DEFAULT_FOLDER);
            }
            catch (ObjectConfigurationException e) {
                throw new DataAccessException("Error retrieving foldername.", (Throwable)((Object)e));
            }
        }
        return DEFAULT_FOLDER;
    }

    private String forwardEmailParam() {
        try {
            return this.getProperty(FORWARD_EMAIL);
        }
        catch (ObjectConfigurationException e) {
            throw new DataAccessException(this.addHandlerInfo("Error retrieving Forward Email flag."), (Throwable)((Object)e));
        }
    }

    @Override
    protected String addHandlerInfo(String msg) {
        return this.getName() + "[" + this.mailserverId + "]: " + msg;
    }

    private static I18nHelper getI18nHelper() {
        return ComponentAccessor.getI18nHelperFactory().getInstance((ApplicationUser)null);
    }

    @Override
    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("MAILFETCHERSERVICE", "services/com/atlassian/jira/service/services/mail/mailfetcherservice.xml", null);
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    private class ErrorEmailForwarderImpl
    implements ErrorEmailForwarder {
        private ErrorEmailForwarderImpl() {
        }

        @Override
        public boolean forwardEmail(Message message, MessageHandlerContext context, String toAddress, String errorsAsString, String exceptionsAsString) {
            if (TextUtils.verifyEmail((String)toAddress)) {
                try {
                    com.atlassian.jira.mail.Email email = this.createErrorForwardEmail(message, context.getMonitor(), toAddress, errorsAsString, exceptionsAsString);
                    this.sendMail(email, context, context.getMonitor());
                    return true;
                }
                catch (VelocityException e) {
                    context.getMonitor().error("Could not create email template for.", e);
                }
                catch (MessagingException e) {
                    context.getMonitor().error("Could not retrieve information from message.", e);
                }
                catch (MailException e) {
                    context.getMonitor().error("Failed to forward the message.", e);
                }
            } else {
                context.getMonitor().warning("Forward Email is invalid.");
            }
            return false;
        }

        private void sendMail(com.atlassian.jira.mail.Email email, MessageHandlerContext context, MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) throws MailException {
            SMTPMailServer mailserver = MailFetcherService.this.getMailServerManager().getDefaultSMTPMailServer();
            if (mailserver == null) {
                messageHandlerExecutionMonitor.warning("You do not currently have a smtp mail server set up yet.");
            } else if (MailFactory.isSendingDisabled()) {
                messageHandlerExecutionMonitor.warning("Sending mail is currently disabled in Jira.");
            } else {
                email.setFrom(mailserver.getDefaultFrom());
                if (context.isRealRun()) {
                    log.debug((Object)("Sending mail to [" + email.getTo() + "]"));
                    mailserver.send((Email)email);
                } else {
                    messageHandlerExecutionMonitor.info("Sending mail to '" + email.getTo() + "'");
                    log.debug((Object)("Sending mail to [" + email.getTo() + "] skipped due to dry-run mode"));
                }
            }
        }

        private com.atlassian.jira.mail.Email createErrorForwardEmail(Message message, MessageHandlerExecutionMonitor monitor, String toAddress, String errorsAsString, @Nullable String exceptionsAsString) throws VelocityException, MessagingException {
            com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(toAddress);
            email.setSubject(MailFetcherService.getI18nHelper().getText("template.errorinhandler.subject", message.getSubject()));
            HashMap<String, Object> contextParams = new HashMap<String, Object>();
            contextParams.putAll(this.getVelocityParams(errorsAsString, monitor));
            String body = this.getTemplatingEngine().render(TemplateSources.file("templates/email/text/errorinhandler.vm")).applying(contextParams).asPlainText();
            email.setBody(body);
            MimeMultipart mp = new MimeMultipart();
            if (exceptionsAsString != null) {
                MimeBodyPart exception = new MimeBodyPart();
                exception.setContent((Object)exceptionsAsString, "text/plain");
                exception.setFileName("ErrorStackTrace.txt");
                mp.addBodyPart((BodyPart)exception);
            }
            MimeBodyPart messageAttachment = new MimeBodyPart();
            messageAttachment.setContent((Object)message, "message/rfc822");
            String subject = message.getSubject();
            if (StringUtils.isBlank((String)subject)) {
                subject = "NoSubject";
            }
            messageAttachment.setFileName(subject + ".eml");
            mp.addBodyPart((BodyPart)messageAttachment);
            email.setMultipart((Multipart)mp);
            return email;
        }

        private Map<String, Object> getVelocityParams(String error, MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String handlerName = MailFetcherService.this.getHandler().getClass().toString();
            try {
                params.put("i18n", MailFetcherService.getI18nHelper());
                params.put("handlerName", handlerName);
                Long serverId = new Long(MailFetcherService.this.getProperty(MailFetcherService.KEY_MAIL_SERVER));
                params.put("serverName", MailFetcherService.this.getMailServerManager().getMailServer(serverId).getName());
                params.put("error", error);
                params.put("baseurl", ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
            }
            catch (ObjectConfigurationException e) {
                messageHandlerExecutionMonitor.error("Could not retrieve mail server", (Throwable)((Object)e));
            }
            catch (MailException e) {
                messageHandlerExecutionMonitor.error("Could not retrieve mail server", e);
            }
            return params;
        }

        @VisibleForTesting
        VelocityTemplatingEngine getTemplatingEngine() {
            return ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
        }
    }

    private class MessageProviderImpl
    implements MessageProvider {
        static final String MESSAGE_ID = "Message-ID";

        private MessageProviderImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getAndProcessMail(MessageProvider.SingleMessageProcessor singleMessageProcessor, MailServer mailserver, MessageHandlerContext context) {
            log.debug((Object)("Using mail server [" + mailserver + "]"));
            String hostname = mailserver.getHostname();
            String username = mailserver.getUsername();
            String password = mailserver.getPassword();
            if (hostname == null || username == null || password == null) {
                context.getMonitor().warning("Cannot retrieve mail due to a missing parameter in Mail Server '" + mailserver.getName() + "': [host," + hostname + "],[username," + username + "],[password," + password + "]");
                return;
            }
            String protocol = mailserver.getMailProtocol().getProtocol();
            Optional<Store> storeOptional = MailFetcherService.this.getStore(mailserver, protocol, context.getMonitor());
            if (!storeOptional.isPresent()) {
                return;
            }
            Store store = (Store)storeOptional.get();
            try {
                int port = MailFetcherService.this.getPort(mailserver);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Connecting to mail store to host [" + hostname + "] and port [" + port + "]"));
                }
                store.connect(hostname, port, username, password);
                log.debug((Object)"Successfully connected to mail store");
            }
            catch (MessagingException e) {
                String environmentInfo = ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage() + " while connecting to host '" + hostname + "' as user '" + username + "' via protocol '" + protocol;
                if (log.isDebugEnabled()) {
                    context.getMonitor().warning(environmentInfo + "': " + (Object)((Object)e), e);
                } else {
                    String cause = "";
                    if (e.getCause() != null) {
                        cause = ", caused by: " + e.getCause().toString();
                    }
                    context.getMonitor().warning(environmentInfo + cause);
                }
                return;
            }
            Folder folder = null;
            ArrayList pop3MessagesToBeDeleted = Lists.newArrayList();
            try {
                String folderName = MailFetcherService.this.getFolderName(mailserver);
                log.debug((Object)("Getting folder [" + folderName + "]"));
                folder = store.getFolder(folderName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got folder [" + folder + "], now opening it for read/write"));
                }
                folder.open(!context.isRealRun() ? 1 : 2);
                Message[] messages = MailFetcherService.this.getUnprocessedMessages(folder);
                log.debug((Object)MailFetcherService.this.addHandlerInfo("Found " + messages.length + " unprocessed message(s) in the " + protocol + " folder"));
                if (!context.isRealRun()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Found ");
                    sb.append(messages.length);
                    sb.append(" unprocessed message(s) in the ");
                    sb.append(protocol);
                    sb.append(" folder.");
                    if (messages.length > 10) {
                        sb.append(" Only first 10 messages will be processed in test mode.");
                    }
                    context.getMonitor().info(sb.toString());
                }
                context.getMonitor().setNumMessages(messages.length);
                int messagesLength = messages.length;
                for (int i = 0; i < messagesLength; ++i) {
                    Message message = messages[i];
                    boolean deleteThisMessage = false;
                    String msgId = null;
                    try {
                        context.getMonitor().nextMessage(message);
                        if (!context.isRealRun() && i >= 10) {
                            log.debug((Object)"In dry-run mode only first 10 messages are processed. Skipping the rest");
                            break;
                        }
                        log.debug((Object)"Processing message");
                        String[] messageIdHeader = message.getHeader(MESSAGE_ID);
                        String string = msgId = messageIdHeader != null ? messageIdHeader[0] : null;
                        if (log.isDebugEnabled()) {
                            try {
                                log.debug((Object)("Message Subject: " + message.getSubject()));
                                log.debug((Object)("Message-ID: " + msgId));
                            }
                            catch (MessagingException e) {
                                context.getMonitor().warning("Messaging exception thrown on getting message subject. Message may have corrupt headers.", e);
                            }
                        }
                        if (MailFetcherService.this.deadLetterStore.exists(msgId, MailFetcherService.this.mailserverId, folderName)) {
                            context.getMonitor().warning("Deleting message '" + message.getSubject() + "' without processing in order to avoid creating duplicate issues/comments." + " This message has been already processed by a mail handler on this mailbox before.");
                            deleteThisMessage = true;
                            continue;
                        }
                        deleteThisMessage = singleMessageProcessor.process(message, context);
                        continue;
                    }
                    catch (FolderClosedException fce) {
                        context.getMonitor().error("The folder has been closed on us, stop processing any more emails: " + fce.getMessage(), fce);
                        log.debug((Object)("The folder was closed while talking to the service: " + mailserver.getHostname()));
                        break;
                    }
                    catch (Exception e) {
                        context.getMonitor().error("Exception: " + e.getLocalizedMessage(), e);
                        continue;
                    }
                    finally {
                        if (message != null) {
                            if (message instanceof POP3Message) {
                                ((POP3Message)message).invalidate(true);
                            }
                            if (deleteThisMessage) {
                                if (context.isRealRun()) {
                                    log.debug((Object)("Deleting Message: " + msgId));
                                    this.deleteMessage(message, msgId, folderName, pop3MessagesToBeDeleted);
                                } else {
                                    context.getMonitor().info("Deleting Message '" + message.getSubject() + "'");
                                    log.debug((Object)("Deleting Message: " + msgId + " (skipped due to dry-run mode)"));
                                }
                            }
                        }
                    }
                }
                this.closeFolderAndStore(context, hostname, store, folder, pop3MessagesToBeDeleted);
            }
            catch (MessagingException e) {
                try {
                    context.getMonitor().error("Messaging Exception in service '" + this.getClass().getName() + "' when getting mail: " + e.getMessage(), e);
                    this.closeFolderAndStore(context, hostname, store, folder, pop3MessagesToBeDeleted);
                }
                catch (Throwable throwable) {
                    this.closeFolderAndStore(context, hostname, store, folder, pop3MessagesToBeDeleted);
                    throw throwable;
                }
            }
        }

        void deleteMessage(Message message, String msgId, String folderName, List<String> pop3MessagesToBeDeleted) throws MessagingException {
            try {
                message.setFlag(Flags.Flag.DELETED, true);
                if (message instanceof POP3Message) {
                    pop3MessagesToBeDeleted.add(msgId);
                    MailFetcherService.this.deadLetterStore.createOrUpdate(msgId, MailFetcherService.this.mailserverId, folderName);
                } else {
                    MailFetcherService.this.deadLetterStore.delete(msgId, MailFetcherService.this.mailserverId, folderName);
                }
            }
            catch (MessagingException ex) {
                MailFetcherService.this.deadLetterStore.createOrUpdate(msgId, MailFetcherService.this.mailserverId, folderName);
                throw ex;
            }
        }

        private void closeFolderAndStore(MessageHandlerContext context, String hostname, Store store, Folder folder, List<String> pop3MessagesToBeDeleted) {
            try {
                if (folder != null) {
                    log.debug((Object)"Closing folder");
                    if (!folder.isOpen()) {
                        context.getMonitor().error("The connection is no longer open, messages marked as deleted will not be purged from the remote server: " + hostname + " until the next run.");
                    }
                    folder.close(true);
                }
                log.debug((Object)"Closing store");
                store.close();
                pop3MessagesToBeDeleted.forEach(msgId -> MailFetcherService.this.deadLetterStore.delete((String)msgId, MailFetcherService.this.mailserverId, MailFetcherService.DEFAULT_FOLDER));
            }
            catch (Exception e) {
                log.debug((Object)MailFetcherService.this.addHandlerInfo("Error whilst closing folder and store: " + e.getMessage()));
            }
        }
    }

    static interface ErrorEmailForwarder {
        public boolean forwardEmail(Message var1, MessageHandlerContext var2, String var3, String var4, String var5);
    }

    static interface MessageProvider {
        public void getAndProcessMail(SingleMessageProcessor var1, MailServer var2, MessageHandlerContext var3);

        public static interface SingleMessageProcessor {
            public boolean process(Message var1, MessageHandlerContext var2) throws MessagingException, MailException;
        }
    }
}

