/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.project.type.ProjectTypeKey;

@PublicApi
public final class ProjectType {
    private final ProjectTypeKey key;
    private final String descriptionI18nKey;
    private final String icon;
    private final String color;
    private final int weight;

    public ProjectType(ProjectTypeKey key, String descriptionI18nKey, String icon, String color, int weight) {
        this.key = key;
        this.descriptionI18nKey = descriptionI18nKey;
        this.icon = icon;
        this.color = color;
        this.weight = weight;
    }

    public ProjectTypeKey getKey() {
        return this.key;
    }

    public String getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectType that = (ProjectType)o;
        if (this.weight != that.weight) {
            return false;
        }
        if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
            return false;
        }
        if (this.descriptionI18nKey != null ? !this.descriptionI18nKey.equals(that.descriptionI18nKey) : that.descriptionI18nKey != null) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(that.icon) : that.icon != null) {
            return false;
        }
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.descriptionI18nKey != null ? this.descriptionI18nKey.hashCode() : 0);
        result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + this.weight;
        return result;
    }
}

