/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.template.ProjectTemplateKey;

@PublicApi
public class ProjectCreatedData {
    private final Project project;
    private final ProjectTemplateKey projectTemplateKey;

    private ProjectCreatedData(Project project, ProjectTemplateKey projectTemplateKey) {
        this.project = project;
        this.projectTemplateKey = projectTemplateKey;
    }

    public Project getProject() {
        return this.project;
    }

    public ProjectTemplateKey getProjectTemplateKey() {
        return this.projectTemplateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectCreatedData that = (ProjectCreatedData)o;
        if (this.project != null ? !this.project.equals(that.project) : that.project != null) {
            return false;
        }
        return !(this.projectTemplateKey != null ? !this.projectTemplateKey.equals(that.projectTemplateKey) : that.projectTemplateKey != null);
    }

    public int hashCode() {
        int result = this.project != null ? this.project.hashCode() : 0;
        result = 31 * result + (this.projectTemplateKey != null ? this.projectTemplateKey.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private Project project;
        private ProjectTemplateKey projectTemplateKey;

        public Builder withProject(Project project) {
            this.project = project;
            return this;
        }

        public Builder withProjectTemplateKey(ProjectTemplateKey projectTemplateKey) {
            this.projectTemplateKey = projectTemplateKey;
            return this;
        }

        public ProjectCreatedData build() {
            return new ProjectCreatedData(this.project, this.projectTemplateKey);
        }
    }
}

