/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;

public class UserClauseValuesGenerator
implements ClauseValuesGenerator {
    private final UserPickerSearchService userPickerSearchService;

    public UserClauseValuesGenerator(UserPickerSearchService userPickerSearchService) {
        this.userPickerSearchService = userPickerSearchService;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList<ClauseValuesGenerator.Result> userValues = new ArrayList<ClauseValuesGenerator.Result>();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(searcher);
        if (this.userPickerSearchService.canPerformAjaxSearch(serviceContext)) {
            List<ApplicationUser> users = this.userPickerSearchService.findUsersAllowEmptyQuery(serviceContext, valuePrefix);
            for (ApplicationUser user : users) {
                if (userValues.size() == maxNumResults) break;
                String fullName = user.getDisplayName();
                String name = user.getName();
                String email = user.getEmailAddress();
                userValues.add(new ClauseValuesGenerator.Result(name, new String[]{fullName, "- " + email, " (" + name + ")"}));
            }
        }
        return new ClauseValuesGenerator.Results(userValues);
    }
}

